/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistoryBuilder;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistoryBuilder;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.internal.api.events.ChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

abstract class ConditionHelper {
    private final ChangeHistoryManager changeHistoryManager;
    private final ChangeItemBeanUtils changeItemBeanUtils;

    ConditionHelper(ChangeHistoryManager changeHistoryManager, ChangeItemBeanUtils changeItemBeanUtils) {
        this.changeHistoryManager = changeHistoryManager;
        this.changeItemBeanUtils = changeItemBeanUtils;
    }

    MatchConditionHistory getMatchHistoryForField(Issue issue, String currentIssueValue, String fieldName, MatchEvent eventWhenSet, MatchEvent eventWhenNotSet) {
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, fieldName);
        MatchConditionHistoryBuilder builder = MatchConditionHistoryBuilder.newBuilder();
        if (CollectionUtils.isEmpty((Collection)changeItems)) {
            if (StringUtils.isEmpty((String)currentIssueValue)) {
                builder.addEntry(new DateTime(issue.getCreated().getTime()), eventWhenNotSet);
            } else {
                builder.addEntry(new DateTime(issue.getCreated().getTime()), eventWhenSet);
            }
        } else {
            for (ChangeItemBean bean : changeItems) {
                FieldChangeType fieldChangeType = this.changeItemBeanUtils.extractFieldChangeType(bean, issue);
                switch (fieldChangeType) {
                    case SET: {
                        if (builder.isEmpty()) {
                            builder.addEntry(new DateTime(issue.getCreated().getTime()), eventWhenNotSet);
                        }
                        builder.addEntry(new DateTime(bean.getCreated().getTime()), eventWhenSet);
                        break;
                    }
                    case CLEAR: {
                        if (builder.isEmpty()) {
                            builder.addEntry(new DateTime(issue.getCreated().getTime()), eventWhenSet);
                        }
                        builder.addEntry(new DateTime(bean.getCreated().getTime()), eventWhenNotSet);
                        break;
                    }
                }
            }
        }
        return builder.build();
    }

    HitConditionHistory getHitHistoryForFieldValueSet(Issue issue, String currentIssueValue, String fieldName) {
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, fieldName);
        HitConditionHistoryBuilder builder = HitConditionHistoryBuilder.newBuilder();
        if (CollectionUtils.isEmpty((Collection)changeItems)) {
            if (StringUtils.isNotEmpty((String)currentIssueValue)) {
                builder.addHit(new DateTime(issue.getCreated().getTime()));
            }
        } else {
            for (int index = 0; index < changeItems.size(); ++index) {
                ChangeItemBean bean = (ChangeItemBean)changeItems.get(index);
                FieldChangeType fieldChangeType = this.changeItemBeanUtils.extractFieldChangeType(bean, issue);
                if (fieldChangeType == FieldChangeType.SET) {
                    builder.addHit(new DateTime(bean.getCreated().getTime()));
                    continue;
                }
                if (index != 0 || !builder.isEmpty()) continue;
                builder.addHit(new DateTime(issue.getCreated().getTime()));
            }
        }
        return builder.build();
    }

    HitConditionHistory getHitHistoryForFieldValueCleared(Issue issue, String fieldName) {
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, fieldName);
        HitConditionHistoryBuilder builder = HitConditionHistoryBuilder.newBuilder();
        for (ChangeItemBean bean : changeItems) {
            FieldChangeType fieldChangeType = this.changeItemBeanUtils.extractFieldChangeType(bean, issue);
            if (fieldChangeType != FieldChangeType.CLEAR) continue;
            builder.addHit(new DateTime(bean.getCreated().getTime()));
        }
        return builder.build();
    }

    HitConditionHistory getHitHistoryForFieldValueChanged(Issue issue, String fieldName) {
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, fieldName);
        HitConditionHistoryBuilder builder = HitConditionHistoryBuilder.newBuilder();
        for (ChangeItemBean bean : changeItems) {
            if (!this.changeItemBeanUtils.isChangeToAnotherValue(bean, issue)) continue;
            builder.addHit(new DateTime(bean.getCreated().getTime()));
        }
        return builder.build();
    }
}

