/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.sla.condition.factory.AssigneeConditionHelper;
import com.atlassian.servicedesk.internal.sla.condition.factory.InternalTimeMetricCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;

class AssigneeSetMatchCondition
implements TimeMetricMatchCondition,
InternalTimeMetricCondition {
    private static final String ASSIGNEE_SET_ID = "assignee-set-match-condition";
    private final AssigneeConditionHelper helper;

    AssigneeSetMatchCondition(AssigneeConditionHelper helper) {
        this.helper = helper;
    }

    public String getId() {
        return ASSIGNEE_SET_ID;
    }

    public String getName(I18nHelper i18n) {
        return i18n.getText(this.getI18nNameKey());
    }

    public String getNameHtml(I18nHelper i18n) {
        return this.getName(i18n);
    }

    public MatchEvent evaluate(Issue issue, SLAChangeEvent event) {
        if (this.helper.isAssigned(issue)) {
            return MatchEvent.MATCH;
        }
        return MatchEvent.INVERSE_MATCH;
    }

    public MatchConditionHistory getHistory(Issue issue) {
        return this.helper.getMatchHistoryForAssigned(issue);
    }

    @Override
    public String getI18nNameKey() {
        return "sd.sla.condition.match.assignee.assigned";
    }
}

