/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition;

import com.atlassian.jira.project.Project;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.sla.condition.ConditionFactoryModuleDescriptor;
import com.atlassian.servicedesk.internal.sla.condition.ConditionFactoryService;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricHitConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricMatchConditionInfo;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricConditionFactory;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConditionFactoryServiceImpl
implements ConditionFactoryService {
    protected final Log log = Log.with(this.getClass());
    @Autowired
    private PluginAccessor pluginAccessor;

    @Override
    public List<TimeMetricHitConditionInfo> getAllHitConditions(Project project) {
        List factoryDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ConditionFactoryModuleDescriptor.class);
        ArrayList conditions = Lists.newArrayList();
        for (ConditionFactoryModuleDescriptor moduleDescriptor : factoryDescriptors) {
            try {
                List all = ((TimeMetricConditionFactory)moduleDescriptor.getModule()).getAllHitConditions(project);
                if (all == null) continue;
                for (TimeMetricHitCondition condition : all) {
                    if (condition == null) continue;
                    conditions.add(new TimeMetricHitConditionInfo(moduleDescriptor.getPluginKey(), moduleDescriptor.getKey(), condition.getId(), (Option<TimeMetricHitCondition>)Option.some((Object)condition)));
                }
            }
            catch (Exception e) {
                this.log.warnDebug(e, "Plugin module %s threw exception %s", new Object[]{moduleDescriptor.getCompleteKey(), e.getMessage()});
            }
        }
        return conditions;
    }

    @Override
    public TimeMetricHitConditionInfo getHitCondition(String pluginKey, String factoryKey, String conditionId) {
        String completeFactoryKey = this.getCompleteFactoryKey(pluginKey, factoryKey);
        if (this.pluginAccessor.isPluginModuleEnabled(completeFactoryKey)) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getPluginModule(completeFactoryKey);
            if (moduleDescriptor instanceof ConditionFactoryModuleDescriptor) {
                try {
                    TimeMetricHitCondition condition = ((TimeMetricConditionFactory)((ConditionFactoryModuleDescriptor)moduleDescriptor).getModule()).getHitCondition(conditionId);
                    if (condition != null) {
                        return new TimeMetricHitConditionInfo(moduleDescriptor.getPluginKey(), moduleDescriptor.getKey(), condition.getId(), (Option<TimeMetricHitCondition>)Option.some((Object)condition));
                    }
                }
                catch (Exception e) {
                    this.log.warnDebug(e, "Plugin module %s threw exception %s", new Object[]{completeFactoryKey, e.getMessage()});
                }
            } else {
                this.log.warn("Plugin module %s should implement %s", new Object[]{completeFactoryKey, ConditionFactoryModuleDescriptor.class.getName()});
            }
        } else {
            this.log.warn("Cannot find condition factory module descriptor %s. Is the plugin present and activated ?", new Object[]{completeFactoryKey});
        }
        return new TimeMetricHitConditionInfo(pluginKey, factoryKey, conditionId, (Option<TimeMetricHitCondition>)Option.none());
    }

    @Override
    public List<TimeMetricMatchConditionInfo> getAllMatchConditions(Project project) {
        List factoryDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ConditionFactoryModuleDescriptor.class);
        ArrayList conditions = Lists.newArrayList();
        for (ConditionFactoryModuleDescriptor moduleDescriptor : factoryDescriptors) {
            try {
                List all = ((TimeMetricConditionFactory)moduleDescriptor.getModule()).getAllMatchConditions(project);
                if (all == null) continue;
                for (TimeMetricMatchCondition condition : all) {
                    if (condition == null) continue;
                    conditions.add(new TimeMetricMatchConditionInfo(moduleDescriptor.getPluginKey(), moduleDescriptor.getKey(), condition.getId(), (Option<TimeMetricMatchCondition>)Option.some((Object)condition)));
                }
            }
            catch (Exception e) {
                this.log.warnDebug(e, "Plugin module %s threw exception %s", new Object[]{moduleDescriptor.getCompleteKey(), e.getMessage()});
            }
        }
        return conditions;
    }

    @Override
    public TimeMetricMatchConditionInfo getMatchCondition(String pluginKey, String factoryKey, String conditionId) {
        String completeFactoryKey = this.getCompleteFactoryKey(pluginKey, factoryKey);
        if (this.pluginAccessor.isPluginModuleEnabled(completeFactoryKey)) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getPluginModule(completeFactoryKey);
            if (moduleDescriptor instanceof ConditionFactoryModuleDescriptor) {
                try {
                    TimeMetricMatchCondition condition = ((TimeMetricConditionFactory)((ConditionFactoryModuleDescriptor)moduleDescriptor).getModule()).getMatchCondition(conditionId);
                    if (condition != null) {
                        return new TimeMetricMatchConditionInfo(moduleDescriptor.getPluginKey(), moduleDescriptor.getKey(), condition.getId(), (Option<TimeMetricMatchCondition>)Option.some((Object)condition));
                    }
                }
                catch (Exception e) {
                    this.log.warnDebug(e, "Plugin module %s threw exception %s", new Object[]{moduleDescriptor.getCompleteKey(), e.getMessage()});
                }
            } else {
                this.log.warn("Plugin module %s should implement %s", new Object[]{factoryKey, ConditionFactoryModuleDescriptor.class.getName()});
            }
        } else {
            this.log.warn("Cannot find condition factory module descriptor:%s. Is the plugin present and activated ?", new Object[]{factoryKey});
        }
        return new TimeMetricMatchConditionInfo(pluginKey, factoryKey, conditionId, (Option<TimeMetricMatchCondition>)Option.none());
    }

    private String getCompleteFactoryKey(String pluginKey, String factoryKey) {
        return pluginKey + ":" + factoryKey;
    }
}

