/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.audit;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogEntry;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogInput;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class SlaAuditLogQStore {
    private static final int AUDIT_LOG_RETRIEVAL_LIMIT = 100;
    private static final int AUDIT_LOG_ISSUE_LIMIT = 5;

    public Map<Long, String> selectIssuesOfSLA(DatabaseConnection connection, long timeMetricId, String issueKeySearchString) {
        List result = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{Tables.SLA_AUDIT_LOG.ISSUE_ID, Tables.SLA_AUDIT_LOG_DATA.VALUE}).from((Expression)Tables.SLA_AUDIT_LOG)).leftJoin((EntityPath)Tables.SLA_AUDIT_LOG_DATA)).on((Predicate)Tables.SLA_AUDIT_LOG.ID.eq(Tables.SLA_AUDIT_LOG_DATA.SLA_AUDIT_LOG_ID))).where((Predicate)this.selectIssuesWhereClause(timeMetricId, issueKeySearchString))).orderBy(Tables.SLA_AUDIT_LOG.EVENT_TIME.desc())).limit(5L)).fetch();
        return this.transformTupleToIssueMap(result);
    }

    private BooleanExpression selectIssuesWhereClause(long timeMetricId, String issueKeySearchPattern) {
        return Tables.SLA_AUDIT_LOG.SLA_ID.eq((Object)timeMetricId).and((Predicate)Tables.SLA_AUDIT_LOG.ISSUE_ID.isNotNull()).and((Predicate)Tables.SLA_AUDIT_LOG_DATA.KEY.eq((Object)"issueKey")).and((Predicate)Tables.SLA_AUDIT_LOG_DATA.VALUE.contains(issueKeySearchPattern));
    }

    public List<SlaAuditLogEntry> selectAuditLogEntries(DatabaseConnection connection, long timeMetricId, Option<Long> issueId, boolean showGlobal) {
        List result = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{Tables.SLA_AUDIT_LOG.EVENT_TIME, Tables.SLA_AUDIT_LOG.ISSUE_ID, Tables.SLA_AUDIT_LOG.SLA_ID, Tables.SLA_AUDIT_LOG.ID, Tables.SLA_AUDIT_LOG.REASON, Tables.SLA_AUDIT_LOG_DATA.KEY, Tables.SLA_AUDIT_LOG_DATA.VALUE}).from((Expression)Tables.SLA_AUDIT_LOG)).leftJoin((EntityPath)Tables.SLA_AUDIT_LOG_DATA)).on((Predicate)Tables.SLA_AUDIT_LOG.ID.eq(Tables.SLA_AUDIT_LOG_DATA.SLA_AUDIT_LOG_ID))).where((Predicate)this.selectWhereClause(timeMetricId, issueId, showGlobal))).orderBy(Tables.SLA_AUDIT_LOG.EVENT_TIME.desc())).limit(100L)).fetch();
        return this.transformTupleToResult(result);
    }

    private BooleanExpression selectWhereClause(long auditLogId, Option<Long> issueId, boolean showGlobal) {
        BooleanExpression whereClause = Tables.SLA_AUDIT_LOG.SLA_ID.eq((Object)auditLogId);
        if (issueId.isDefined()) {
            whereClause = whereClause.and((Predicate)Tables.SLA_AUDIT_LOG.ISSUE_ID.eq(issueId.get())).or((Predicate)Tables.SLA_AUDIT_LOG.ISSUE_ID.eq(issueId.get()).and((Predicate)Tables.SLA_AUDIT_LOG.SLA_ID.isNull()));
        }
        if (showGlobal) {
            whereClause = whereClause.or((Predicate)Tables.SLA_AUDIT_LOG.ISSUE_ID.isNull().and((Predicate)Tables.SLA_AUDIT_LOG.SLA_ID.isNull()));
        }
        return whereClause;
    }

    private List<SlaAuditLogEntry> transformTupleToResult(List<Tuple> result) {
        LinkedHashMap<Long, SlaAuditLogEntry.Builder> resultBuilderPerAuditLogId = new LinkedHashMap<Long, SlaAuditLogEntry.Builder>();
        for (Tuple tuple : result) {
            Long auditLogId = (Long)tuple.get(Tables.SLA_AUDIT_LOG.ID);
            resultBuilderPerAuditLogId.compute(auditLogId, (id, value) -> this.determineBuilder(tuple, (Long)id, (SlaAuditLogEntry.Builder)value));
        }
        return resultBuilderPerAuditLogId.values().stream().map(SlaAuditLogEntry.Builder::build).collect(Collectors.toList());
    }

    private Map<Long, String> transformTupleToIssueMap(List<Tuple> result) {
        TreeMap<Long, String> issueIdToKeyMap = new TreeMap<Long, String>();
        for (Tuple tuple : result) {
            Long issueId = (Long)tuple.get(Tables.SLA_AUDIT_LOG.ISSUE_ID);
            String issueKey = (String)tuple.get((Expression)Tables.SLA_AUDIT_LOG_DATA.VALUE);
            issueIdToKeyMap.put(issueId, issueKey);
        }
        return issueIdToKeyMap;
    }

    private SlaAuditLogEntry.Builder determineBuilder(Tuple tuple, Long id, SlaAuditLogEntry.Builder value) {
        SlaAuditLogEntry.Builder builder = value == null ? this.initializeNewBuilder(id, tuple) : value;
        this.addDataToBuilder(builder, tuple);
        return builder;
    }

    private SlaAuditLogEntry.Builder initializeNewBuilder(long id, Tuple tuple) {
        return SlaAuditLogEntry.Builder.newBuilder(id).eventTime((Long)tuple.get(Tables.SLA_AUDIT_LOG.EVENT_TIME)).issueId((Long)tuple.get(Tables.SLA_AUDIT_LOG.ISSUE_ID)).timeMetricId((Long)tuple.get(Tables.SLA_AUDIT_LOG.SLA_ID)).reason(this.getReason(tuple));
    }

    private void addDataToBuilder(SlaAuditLogEntry.Builder builder, Tuple tuple) {
        Option.option((Object)tuple.get((Expression)Tables.SLA_AUDIT_LOG_DATA.KEY)).forEach(key -> builder.addData((String)key, (String)tuple.get((Expression)Tables.SLA_AUDIT_LOG_DATA.VALUE)));
    }

    private Option<SlaAuditLogReason> getReason(Tuple tuple) {
        try {
            return Option.option((Object)tuple.get((Expression)Tables.SLA_AUDIT_LOG.REASON)).map(SlaAuditLogReason::valueOf);
        }
        catch (IllegalArgumentException e) {
            return Option.none();
        }
    }

    public void insertIntoAuditLog(DatabaseConnection connection, Collection<SlaAuditLogInput> inputs) {
        for (SlaAuditLogInput input : inputs) {
            Long auditLogId = this.insertAuditLog(connection, input);
            input.getData().forEach(data -> this.insertData(connection, (Map<String, String>)data, auditLogId));
        }
    }

    private Long insertAuditLog(DatabaseConnection connection, SlaAuditLogInput input) {
        SQLInsertClause insertClause = connection.insert((RelationalPath)Tables.SLA_AUDIT_LOG).set(Tables.SLA_AUDIT_LOG.EVENT_TIME, (Object)input.getTimeStamp()).set((Path)Tables.SLA_AUDIT_LOG.REASON, input.getReason().map(Enum::name).getOrNull());
        input.getIssueId().forEach(issueId -> insertClause.set(Tables.SLA_AUDIT_LOG.ISSUE_ID, issueId));
        input.getTimeMetricId().forEach(timeMetricId -> insertClause.set(Tables.SLA_AUDIT_LOG.SLA_ID, timeMetricId));
        return (Long)insertClause.executeWithKey(Tables.SLA_AUDIT_LOG.ID);
    }

    private void insertData(DatabaseConnection connection, Map<String, String> data, Long auditLogId) {
        SQLInsertClause insertClause = connection.insert((RelationalPath)Tables.SLA_AUDIT_LOG_DATA);
        for (String key : data.keySet()) {
            insertClause.set((Path)Tables.SLA_AUDIT_LOG_DATA.KEY, (Object)key).set((Path)Tables.SLA_AUDIT_LOG_DATA.VALUE, (Object)data.get(key)).set(Tables.SLA_AUDIT_LOG_DATA.SLA_AUDIT_LOG_ID, (Object)auditLogId).addBatch();
        }
        insertClause.execute();
    }
}

