/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.audit;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogEntry;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogInput;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogQStore;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaAuditLogManager {
    private final SlaAuditLogQStore slaAuditLogQStore = new SlaAuditLogQStore();
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public SlaAuditLogManager(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    Map<Long, String> retrieveIssueListOfTimeMetric(long timeMetricId, String issueKeySearchString) {
        return (Map)this.databaseAccessor.runInTransaction(connection -> this.slaAuditLogQStore.selectIssuesOfSLA((DatabaseConnection)connection, timeMetricId, issueKeySearchString));
    }

    List<SlaAuditLogEntry> retrieveAuditEntries(long timeMetricId, Option<Long> issueId, boolean showGlobal) {
        return (List)this.databaseAccessor.runInTransaction(connection -> this.slaAuditLogQStore.selectAuditLogEntries((DatabaseConnection)connection, timeMetricId, issueId, showGlobal));
    }

    public void createAuditLogRecords(Collection<SlaAuditLogInput> inputs, DatabaseConnection databaseConnection) {
        this.slaAuditLogQStore.insertIntoAuditLog(databaseConnection, inputs);
    }

    public void createAuditLogRecords(Collection<SlaAuditLogInput> inputs) {
        this.databaseAccessor.runInTransaction(connection -> {
            this.slaAuditLogQStore.insertIntoAuditLog((DatabaseConnection)connection, inputs);
            return Unit.Unit();
        });
    }
}

