/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.audit;

import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SlaAuditLogEntry {
    private final long id;
    private final long eventTime;
    private final Option<Long> issueId;
    private final Option<Long> timeMetricId;
    private final Option<SlaAuditLogReason> reason;
    private final Map<String, String> data;

    public SlaAuditLogEntry(long id, long eventTime, Option<Long> issueId, Option<Long> timeMetricId, Option<SlaAuditLogReason> reason, Map<String, String> data) {
        this.id = id;
        this.eventTime = eventTime;
        this.issueId = issueId;
        this.timeMetricId = timeMetricId;
        this.reason = reason;
        this.data = data;
    }

    public long getId() {
        return this.id;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public Option<Long> getIssueId() {
        return this.issueId;
    }

    public Option<Long> getTimeMetricId() {
        return this.timeMetricId;
    }

    public Option<SlaAuditLogReason> getReason() {
        return this.reason;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlaAuditLogEntry that = (SlaAuditLogEntry)o;
        return this.id == that.id && this.eventTime == that.eventTime && Objects.equals(this.issueId, that.issueId) && Objects.equals(this.timeMetricId, that.timeMetricId) && Objects.equals(this.reason, that.reason) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.eventTime, this.issueId, this.timeMetricId, this.reason, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("eventTime", this.eventTime).add("issueId", this.issueId).add("timeMetricId", this.timeMetricId).add("reason", this.reason).add("data", this.data).toString();
    }

    static class Builder {
        private final long id;
        private long eventTime;
        private Option<Long> issueId = Option.none();
        private Option<Long> timeMetricId = Option.none();
        private Option<SlaAuditLogReason> reason = Option.none();
        private Map<String, String> data = new HashMap<String, String>();

        static Builder newBuilder(long id) {
            return new Builder(id);
        }

        public Builder(long id) {
            this.id = id;
        }

        Builder eventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        Builder issueId(Long issueId) {
            this.issueId = Option.option((Object)issueId);
            return this;
        }

        Builder timeMetricId(Long timeMetricId) {
            this.timeMetricId = Option.option((Object)timeMetricId);
            return this;
        }

        Builder reason(Option<SlaAuditLogReason> reason) {
            this.reason = reason;
            return this;
        }

        Builder addData(String key, String value) {
            this.data.put(key, value);
            return this;
        }

        SlaAuditLogEntry build() {
            return new SlaAuditLogEntry(this.id, this.eventTime, this.issueId, this.timeMetricId, this.reason, Collections.unmodifiableMap(this.data));
        }
    }
}

