/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class PermissionServiceImpl
implements PermissionService {
    protected final Log log = Log.with(this.getClass());
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private GlobalPermissionManager globalPermissionManager;

    public boolean isJiraAdministrator(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    public boolean isProjectAdmin(ApplicationUser user, ServiceDesk serviceDesk) {
        Project project = this.projectManager.getProjectObj(Long.valueOf(serviceDesk.getProjectId()));
        if (project == null) {
            this.log.warn("This Service Desk isn't linked to any project. Maybe the data is inconsistent ?", new Object[0]);
            return false;
        }
        return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }

    public boolean canAdministerSomeProject(ApplicationUser user) {
        return !this.permissionManager.getProjects(ProjectPermissions.ADMINISTER_PROJECTS, user).isEmpty();
    }

    public boolean canManageSlas(ApplicationUser user, ServiceDesk serviceDesk) {
        return this.isProjectAdmin(user, serviceDesk) || this.isJiraAdministrator(user);
    }

    public boolean canBrowseSomeProject(ApplicationUser user) {
        return !this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user).isEmpty();
    }

    public boolean canViewProject(ApplicationUser user, long projectId) {
        Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
        if (project == null) {
            this.log.warn("This Service Desk isn't linked to any project. Maybe the data is inconsistent ?", new Object[0]);
            return false;
        }
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user);
    }
}

