/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class ReorderQueuesHelper {
    public static List<ReorderOperation> determineReordersToDo(List<Long> currentOrder, List<Long> desiredOrder) {
        ReorderQueuesHelper.ensurePreconditionsAreTrue(currentOrder, desiredOrder);
        return ReorderQueuesHelper.determineReordersToDo(currentOrder, desiredOrder, 0);
    }

    private static List<ReorderOperation> determineReordersToDo(List<Long> currentOrder, List<Long> desiredOrder, int index) {
        Long desiredQ;
        if (index == desiredOrder.size()) {
            return Collections.emptyList();
        }
        Long currentQ = currentOrder.get(index);
        if (currentQ.equals(desiredQ = desiredOrder.get(index))) {
            return ReorderQueuesHelper.determineReordersToDo(currentOrder, desiredOrder, index + 1);
        }
        List<Long> orderAfterMovingCurrent = ReorderQueuesHelper.moveElement(currentOrder.indexOf(desiredQ), index, currentOrder);
        Long queueAboveCurrentId = index == 0 ? Long.valueOf(-1L) : currentOrder.get(index - 1);
        return ImmutableList.builder().add((Object)new ReorderOperation(desiredQ, queueAboveCurrentId)).addAll(ReorderQueuesHelper.determineReordersToDo(orderAfterMovingCurrent, desiredOrder, index + 1)).build();
    }

    private static List<Long> moveElement(int posFrom, int posTo, List<Long> list) {
        ArrayList<Long> updatedList = new ArrayList<Long>(list);
        updatedList.add(posTo, (Long)updatedList.remove(posFrom));
        return updatedList;
    }

    private static void ensurePreconditionsAreTrue(List<Long> list1, List<Long> list2) {
        HashSet<Long> set1 = new HashSet<Long>(list1);
        HashSet<Long> set2 = new HashSet<Long>(list2);
        if (list1.size() != set1.size() || list2.size() != set2.size()) {
            throw new RuntimeException("The list of queue IDs MUST contain unique elements.");
        }
        if (!set1.equals(set2)) {
            throw new RuntimeException("The queue IDs in both lists must match.");
        }
    }

    public static class ReorderOperation {
        private final Long queueId;
        private final Long queueAboveId;

        @VisibleForTesting
        ReorderOperation(Long queueId, Long queueAboveId) {
            this.queueId = queueId;
            this.queueAboveId = queueAboveId;
        }

        public Long getQueueId() {
            return this.queueId;
        }

        public Long getQueueAboveId() {
            return this.queueAboveId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReorderOperation that = (ReorderOperation)o;
            return Objects.equals(this.queueId, that.queueId) && Objects.equals(this.queueAboveId, that.queueAboveId);
        }

        public int hashCode() {
            return Objects.hash(this.queueId, this.queueAboveId);
        }

        public String toString() {
            return "ReorderOperation{queueId=" + this.queueId + ", queueAboveId=" + this.queueAboveId + '}';
        }
    }
}

