/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.upgrade;

import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.bootstrap.upgrade.InternalAsyncUpgradeTaskService;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskException;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.rest.upgrade.reponse.AsyncUpgradeTaskResponse;
import com.atlassian.servicedesk.internal.rest.upgrade.reponse.AsyncUpgradeTasksResponse;
import com.atlassian.servicedesk.internal.upgrade.AsyncUpgradeTaskRecord;
import io.atlassian.fugue.Unit;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/upgrades")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AsyncUpgradeTaskResource {
    private final InternalAsyncUpgradeTaskService asyncUpgradeTaskService;
    private final SyncUpgradeTaskService syncUpgradeTaskService;
    private final PermissionService permissionService;
    private final UserFactory userFactory;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;

    public AsyncUpgradeTaskResource(InternalAsyncUpgradeTaskService asyncUpgradeTaskService, SyncUpgradeTaskService syncUpgradeTaskService, PermissionService permissionService, UserFactory userFactory, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper) {
        this.asyncUpgradeTaskService = asyncUpgradeTaskService;
        this.syncUpgradeTaskService = syncUpgradeTaskService;
        this.permissionService = permissionService;
        this.userFactory = userFactory;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @POST
    @Path(value="/")
    public Response runAllAsyncUpgradeTasks() {
        UncheckedUser currentUser = this.userFactory.getUncheckedUser();
        if (!this.permissionService.isJiraAdministrator(currentUser.forJIRA())) {
            return this.restResponseHelper.anErrorToResponse(this.errorResultHelper.forbidden403("sd.async.upgrade.task.error.admin.permission.required", new Object[0]).build());
        }
        try {
            this.syncUpgradeTaskService.runAll();
        }
        catch (SyncUpgradeTaskException e) {
            return this.restResponseHelper.anErrorToResponse(this.errorResultHelper.internalServiceError500("sd.sync.upgrade.task.error.errors.occured", new Object[0]).build());
        }
        return this.restResponseHelper.errorsEitherToNoContentResponse(this.asyncUpgradeTaskService.runAll().map(unit -> Unit.Unit()));
    }

    @GET
    @Path(value="/")
    public Response getAsyncUpgradeTasksExecutionsHistory() {
        List<AsyncUpgradeTaskRecord> upgradeTasksRecords = this.asyncUpgradeTaskService.getUpgradeTasksRecords();
        return this.restResponseHelper.ok((Object)this.from(upgradeTasksRecords));
    }

    private AsyncUpgradeTasksResponse from(List<AsyncUpgradeTaskRecord> upgradeTasksRecords) {
        AsyncUpgradeTasksResponse response = new AsyncUpgradeTasksResponse();
        for (AsyncUpgradeTaskRecord upgradeTaskRecord : upgradeTasksRecords) {
            response.asyncUpgradeTaskResponses.add(this.from(upgradeTaskRecord));
        }
        return response;
    }

    private AsyncUpgradeTaskResponse from(AsyncUpgradeTaskRecord record) {
        AsyncUpgradeTaskResponse response = new AsyncUpgradeTaskResponse();
        response.upgradeTaskName = record.getUpgradeTaskName();
        response.executionDateTime = record.getExecutionDate();
        response.status = record.getStatus();
        response.versionIntroduced = record.getVersionIntroduced();
        response.executionOutcomeMessage = record.getExecutionOutcomeMessage();
        return response;
    }
}

