/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.temporary;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.rest.temporary.CustomerPortalPermissionsUtil;
import com.google.common.base.Predicate;
import io.atlassian.fugue.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CustomerPortalPermissionsElevationCheckService {
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final ProjectManager projectManager;
    private final UserSearchManager userSearchManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final CustomerContextService customerContextService;
    private final CustomerPortalPermissionsUtil customerPortalPermissionUtil;
    private final ApplicationRoleManager applicationRoleManager;

    @Autowired
    public CustomerPortalPermissionsElevationCheckService(ServiceDeskInternalManager serviceDeskInternalManager, ProjectManager projectManager, UserSearchManager userSearchManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, CustomerContextService customerContextService, CustomerPortalPermissionsUtil customerPortalPermissionUtil, ApplicationRoleManager applicationRoleManager) {
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.projectManager = projectManager;
        this.userSearchManager = userSearchManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.customerContextService = customerContextService;
        this.customerPortalPermissionUtil = customerPortalPermissionUtil;
        this.applicationRoleManager = applicationRoleManager;
    }

    Either<AnError, Map<Project, Set<ApplicationUser>>> findPermissionElevationCustomers(ApplicationUser user) {
        Either<AnError, Unit> permCheck = this.customerPortalPermissionUtil.canUseResource(user);
        if (permCheck.isLeft()) {
            return Either.left((Object)permCheck.left().get());
        }
        NoExceptionsCallable callable = this::findPermissionElevationCustomers;
        Map result = (Map)this.customerContextService.runInCustomerContext(callable);
        return Either.right((Object)result);
    }

    private Map<Project, Set<ApplicationUser>> findPermissionElevationCustomers() {
        HashMap<Project, Set<ApplicationUser>> usersPerProject = new HashMap<Project, Set<ApplicationUser>>();
        List<ServiceDesk> allEnabledServiceDesks = this.serviceDeskInternalManager.getAllEnabledServiceDesks();
        for (ServiceDesk serviceDesk : allEnabledServiceDesks) {
            Project project = this.projectManager.getProjectObj(Long.valueOf(serviceDesk.getProjectId()));
            if (project == null) continue;
            Set<ApplicationUser> usersWithoutCreate = this.findCustomersWithoutCreate(project);
            usersPerProject.put(project, usersWithoutCreate);
        }
        return usersPerProject;
    }

    private Set<ApplicationUser> findCustomersWithoutCreate(Project project) {
        UserSearchParams userSearchParams = UserSearchParams.builder().allowEmptyQuery(true).includeActive(true).includeInactive(false).maxResults(null).filter(this.getCustomerWithPermissionElevationPredicate(project)).build();
        Stream search = this.userSearchManager.searchUnlimited("", userSearchParams);
        return search.collect(Collectors.toSet());
    }

    private Predicate<User> getCustomerWithPermissionElevationPredicate(Project project) {
        return user -> this.isCustomerWithPermissionElevation(project, ApplicationUsers.from((User)user));
    }

    private boolean isCustomerWithPermissionElevation(Project project, ApplicationUser user) {
        boolean hasBrowsePermissionInJIRA;
        if (user == null) {
            return false;
        }
        if (this.isSysadmin(user)) {
            return false;
        }
        if (this.applicationRoleManager.hasAnyRole(user) && (hasBrowsePermissionInJIRA = this.checkBrowsePermission(project, user))) {
            return false;
        }
        return this.checkBrowseAndNotCreateInPortalContext(project, user);
    }

    boolean checkBrowseAndNotCreateInPortalContext(Project project, ApplicationUser user) {
        return (Boolean)this.customerContextService.runInCustomerContext(() -> {
            boolean hasBrowsePermission = this.checkBrowsePermission(project, user);
            if (!hasBrowsePermission) {
                return false;
            }
            boolean hasCreatePermission = this.checkCreatePermission(project, user);
            return !hasCreatePermission;
        });
    }

    private boolean isSysadmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    private boolean checkBrowsePermission(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user);
    }

    private boolean checkCreatePermission(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, user);
    }
}

