/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.temporary;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.temporary.CustomerPortalPermissionsElevationCheckService;
import com.atlassian.servicedesk.internal.rest.temporary.CustomerPortalPermissionsResourceUtil;
import io.atlassian.fugue.Either;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/temporary/customerpermissionelevationcheck")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomerPortalPermissionsElevationCheckResource {
    private final CustomerPortalPermissionsElevationCheckService helper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final RestResponseHelper restResponseHelper;

    @Autowired
    public CustomerPortalPermissionsElevationCheckResource(CustomerPortalPermissionsElevationCheckService helper, JiraAuthenticationContext jiraAuthenticationContext, RestResponseHelper restResponseHelper) {
        this.helper = helper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="affectedusercount")
    public Response getAffectedUserCount() {
        Either<AnError, Map<Project, Set<ApplicationUser>>> data = this.helper.findPermissionElevationCustomers(this.jiraAuthenticationContext.getUser());
        Either affectedUserCount = data.map(CustomerPortalPermissionsResourceUtil::getAffectedUserCount);
        return this.restResponseHelper.anErrorEitherToOkResponse(affectedUserCount);
    }

    @GET
    @Path(value="affectedprojectcount")
    public Response getAffectedProjectCount() {
        Either<AnError, Map<Project, Set<ApplicationUser>>> data = this.helper.findPermissionElevationCustomers(this.jiraAuthenticationContext.getUser());
        Either affectedProjectCount = data.map(CustomerPortalPermissionsResourceUtil::getAffectedProjectCount);
        return this.restResponseHelper.anErrorEitherToOkResponse(affectedProjectCount);
    }

    @GET
    @Path(value="data")
    public Response getSimpleResult() {
        Either<AnError, Map<Project, Set<ApplicationUser>>> data = this.helper.findPermissionElevationCustomers(this.jiraAuthenticationContext.getUser());
        Either result = data.map(d -> CustomerPortalPermissionsResourceUtil.toResult(d, false));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="data/extended")
    public Response getDetailedResult() {
        Either<AnError, Map<Project, Set<ApplicationUser>>> data = this.helper.findPermissionElevationCustomers(this.jiraAuthenticationContext.getUser());
        Either result = data.map(d -> CustomerPortalPermissionsResourceUtil.toResult(d, true));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }
}

