/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.debug.response;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugCustomField;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugGoalData;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricDefinitionResponse;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.joda.time.DateTime;

public class DebugTimeMetricData {
    @XmlElement
    public Integer id;
    @XmlElement
    public String name;
    @XmlElement
    public DebugCustomField customField;
    @XmlElement
    public Boolean customFieldMissing;
    @XmlElement
    public DateTime definitionChangeDate;
    @XmlElement
    public String definitionChangeDateString;
    @XmlElement
    public Long definitionChangeMsEpoch;
    @XmlElement
    public DateTime goalsChangeDate;
    @XmlElement
    public String goalsChangeDateString;
    @XmlElement
    public TimeMetricDefinitionResponse definition;
    @XmlElement
    public List<DebugGoalData> goals;

    public static DebugTimeMetricData from(TimeMetric timeMetric, CustomField customField, TimeMetricDefinitionResponse definition, List<DebugGoalData> goals) {
        DebugTimeMetricData data = new DebugTimeMetricData();
        data.id = timeMetric.getId();
        data.name = timeMetric.getName();
        if (customField != null) {
            data.customField = DebugCustomField.from(customField);
            data.customFieldMissing = false;
        } else {
            data.customFieldMissing = true;
        }
        data.definitionChangeDate = timeMetric.getDefinitionChangeDate();
        data.definitionChangeDateString = data.definitionChangeDate.toString();
        data.definitionChangeMsEpoch = timeMetric.getDefinitionChangeMsEpoch();
        data.goalsChangeDate = timeMetric.getGoalsChangeDate();
        data.goalsChangeDateString = data.goalsChangeDate.toString();
        data.definition = definition;
        data.goals = goals;
        return data;
    }
}

