/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.debug.response;

import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugTimeline;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

public class DebugSLAValue {
    @JsonProperty
    public Boolean isInvalid;
    @JsonProperty
    public String rawValue;
    @JsonProperty
    public String reason;
    @JsonProperty
    public DebugTimeline timeline;
    @JsonProperty
    public OngoingSLAData ongoingSLAData;
    @JsonProperty
    public List<CompleteSLAData> completeSLAData;
    @JsonProperty
    private Integer metricId;
    @JsonProperty
    private DateTime definitionChangeDate;
    @JsonProperty
    private Long definitionChangeMsEpoch;
    @JsonProperty
    private String definitionChangeDateString;
    @JsonProperty
    private DateTime goalsChangeDate;
    @JsonProperty
    private String goalsChangeDateString;
    @JsonProperty
    private Long goalsChangeMsEpoch;
    @JsonProperty
    private DateTime goalTimeUpdatedDate;
    @JsonProperty
    private String goalTimeUpdatedDateString;
    @JsonProperty
    private Long goalTimeUpdatedMsEpoch;
    @JsonProperty
    private Long customFieldId;
    @JsonProperty
    private String customFieldName;
    @JsonProperty
    private Long metricCreatedDate;

    public static DebugSLAValue from(SLAValue slaValue, Long customFieldId, String customFieldName) {
        DebugSLAValue value = new DebugSLAValue();
        value.timeline = DebugTimeline.from(slaValue.getTimeline());
        value.ongoingSLAData = slaValue.getOngoingSLAData();
        value.completeSLAData = slaValue.getCompleteSLAData();
        value.metricId = slaValue.getMetricId();
        value.definitionChangeDate = slaValue.getDefinitionChangeDate();
        if (value.definitionChangeDate != null) {
            value.definitionChangeDateString = value.definitionChangeDate.toString();
        }
        value.definitionChangeMsEpoch = slaValue.getDefinitionChangeMsEpoch();
        value.goalsChangeDate = slaValue.getGoalsChangeDate();
        if (value.goalsChangeDate != null) {
            value.goalsChangeDateString = value.goalsChangeDate.toString();
        }
        value.goalsChangeMsEpoch = slaValue.getGoalsChangeMsEpoch();
        value.goalTimeUpdatedDate = slaValue.getGoalTimeUpdatedDate();
        if (value.goalTimeUpdatedDate != null) {
            value.goalTimeUpdatedDateString = value.goalTimeUpdatedDate.toString();
        }
        value.goalTimeUpdatedMsEpoch = slaValue.getGoalTimeUpdatedMsEpoch();
        value.customFieldId = customFieldId;
        value.customFieldName = customFieldName;
        value.metricCreatedDate = slaValue.getMetricCreatedDate();
        return value;
    }

    public static DebugSLAValue fromInvalid(String reason, String rawValue, Long customFieldId, String customFieldName) {
        DebugSLAValue value = new DebugSLAValue();
        value.isInvalid = true;
        value.reason = reason;
        value.rawValue = rawValue;
        value.customFieldId = customFieldId;
        value.customFieldName = customFieldName;
        return value;
    }
}

