/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.debug.response;

import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

public class DebugConditionHistory {
    @JsonProperty(value="events")
    public List<DebugHistoryEvent> events = Lists.newArrayList();

    public static DebugConditionHistory from(HitConditionHistory history) {
        DebugConditionHistory result = new DebugConditionHistory();
        for (DateTime date : history.getHits()) {
            result.events.add(DebugConditionHistory.from(date, EntryType.HIT));
        }
        return result;
    }

    public static DebugConditionHistory from(MatchConditionHistory history) {
        DebugConditionHistory result = new DebugConditionHistory();
        for (MatchConditionHistory.Entry entry : history.getEntries()) {
            result.events.add(DebugConditionHistory.from(entry));
        }
        return result;
    }

    public static DebugHistoryEvent from(MatchConditionHistory.Entry entry) {
        return DebugConditionHistory.from(entry.getDateTime(), entry.getMatchEvent().isMatch() ? EntryType.MATCH : EntryType.INVERSE_MATCH);
    }

    public static DebugHistoryEvent from(DateTime date, EntryType type) {
        DebugHistoryEvent event = new DebugHistoryEvent();
        event.date = date;
        event.dateString = date.toString();
        event.type = type;
        return event;
    }

    public static class DebugHistoryEvent {
        @JsonProperty
        public DateTime date;
        @JsonProperty
        public String dateString;
        @JsonProperty
        public EntryType type;
    }

    static enum EntryType {
        HIT,
        MATCH,
        INVERSE_MATCH;

    }
}

