/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.agentview;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.report.CustomReportService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.agentview.MetricRequest;
import com.atlassian.servicedesk.internal.rest.sla.agentview.ServiceDeskSlaHelper;
import com.atlassian.servicedesk.internal.rest.sla.response.ReportListResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.ReportResponse;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricAgentConfigService;
import io.atlassian.fugue.Eithers;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/agent/{projectKey}/sla")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServiceDeskSlaResource {
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final UserFactory userFactory;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ServiceDeskSlaHelper serviceDeskSlaHelper;
    private final TimeMetricAgentConfigService timeMetricAgentConfigService;
    private final CustomReportService customReportService;
    private final RestResponseHelper restResponseHelper;

    public ServiceDeskSlaResource(InternalServiceDeskProjectManager internalServiceDeskProjectManager, UserFactory userFactory, InternalServiceDeskService internalServiceDeskService, ServiceDeskSlaHelper serviceDeskSlaHelper, TimeMetricAgentConfigService timeMetricAgentConfigService, RestResponseHelper restResponseHelper, CustomReportService customReportService) {
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.userFactory = userFactory;
        this.internalServiceDeskService = internalServiceDeskService;
        this.serviceDeskSlaHelper = serviceDeskSlaHelper;
        this.timeMetricAgentConfigService = timeMetricAgentConfigService;
        this.restResponseHelper = restResponseHelper;
        this.customReportService = customReportService;
    }

    @GET
    @Path(value="/metrics")
    public Response getMetricsConfiguration(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either params = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).then((user, project, serviceDesk) -> this.serviceDeskSlaHelper.getMetricParams((CheckedUser)user, (ServiceDesk)serviceDesk, (Project)project)).yield((user, project, serviceDesk, metricsParams) -> metricsParams);
        return this.restResponseHelper.anErrorEitherToOkResponse(params);
    }

    @GET
    @Path(value="/metrics/calendar-refs")
    public Response getCalendarRefs(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either calendars = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).then((user, project, serviceDesk) -> this.serviceDeskSlaHelper.getCalendarReferences((CheckedUser)user, (ServiceDesk)serviceDesk)).yield((user, project, serviceDesk, cals) -> cals);
        return this.restResponseHelper.anErrorEitherToOkResponse(calendars);
    }

    @PUT
    @Path(value="/metrics/{metricId}/validate")
    public Response validateMetric(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") long metricId, MetricRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).yield((user, project, serviceDesk) -> (Response)this.timeMetricAgentConfigService.isValidMetric(user.forJIRA(), (ServiceDesk)serviceDesk, request).fold(errorCollection -> this.convertErrorCollectionToResponse("Validation failed", (ErrorCollection)errorCollection), res -> Response.noContent().build()));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    @POST
    @Path(value="/metrics")
    public Response addMetric(@PathParam(value="projectKey") String projectKey, MetricRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).yield((user, project, serviceDesk) -> (Response)this.timeMetricAgentConfigService.createMetric(user.forJIRA(), (ServiceDesk)serviceDesk, request).fold(errorCollection -> this.convertErrorCollectionToResponse("Creation failed", (ErrorCollection)errorCollection), metric -> this.restResponseHelper.ok((Object)this.serviceDeskSlaHelper.toTimeMetricResponse((CheckedUser)user, (Project)project, (ServiceDesk)serviceDesk, (TimeMetric)((Object)((Object)metric))))));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    @PUT
    @Path(value="/metrics/{metricId}")
    public Response updateMetric(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") int metricId, MetricRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).yield((user, project, serviceDesk) -> (Response)this.timeMetricAgentConfigService.updateMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId, request).fold(errorCollection -> this.convertErrorCollectionToResponse("Update failed", (ErrorCollection)errorCollection), metric -> this.restResponseHelper.ok((Object)this.serviceDeskSlaHelper.toTimeMetricResponse((CheckedUser)user, (Project)project, (ServiceDesk)serviceDesk, (TimeMetric)((Object)((Object)metric))))));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    @GET
    @Path(value="/metrics/{metricId}")
    public Response getMetric(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") int metricId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).yield((user, project, serviceDesk) -> (Response)this.timeMetricAgentConfigService.getMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId).fold(errorCollection -> this.convertErrorCollectionToResponse("Load failed", (ErrorCollection)errorCollection), metric -> this.restResponseHelper.ok((Object)this.serviceDeskSlaHelper.toTimeMetricResponse((CheckedUser)user, (Project)project, (ServiceDesk)serviceDesk, (TimeMetric)((Object)((Object)metric))))));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    @DELETE
    @Path(value="/metrics/{metricId}")
    public Response deleteMetric(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") int metricId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).yield((user, project, serviceDesk) -> (Response)this.timeMetricAgentConfigService.deleteMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId).fold(errorCollection -> this.convertErrorCollectionToResponse("Delete failed", (ErrorCollection)errorCollection), res -> Response.noContent().build()));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    @GET
    @Path(value="/metrics/reports/{metricId}")
    public Response getReportsUsingMetricAsSeries(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") long metricId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).then((user, project, serviceDesk) -> this.customReportService.getReportsForTimeMetric(user.forJIRA(), project, serviceDesk, metricId)).yield((user, project, serviceDesk, reports) -> new ReportListResponse(reports.stream().map(r -> new ReportResponse(r.getId(), r.getName())).collect(Collectors.toList())));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/goals/reports/{goalIds}")
    public Response getReportsUsingGoalAsSeries(@PathParam(value="projectKey") String projectKey, @PathParam(value="goalIds") String goalIds) {
        List goalIDList = Arrays.asList(goalIds.split(",")).stream().map(st -> Integer.valueOf(st)).collect(Collectors.toList());
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).then((user, project, serviceDesk) -> this.customReportService.getReportsForGoalIds(user.forJIRA(), project, serviceDesk, goalIDList)).yield((user, project, serviceDesk, reports) -> new ReportListResponse(reports.stream().map(r -> new ReportResponse(r.getId(), r.getName())).collect(Collectors.toList())));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/consistencydata")
    public Response getSlaConsistencyData(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, Boolean.FALSE.booleanValue())).then((user, project, serviceDesk) -> this.serviceDeskSlaHelper.getSLAConsistencyData((CheckedUser)user, (ServiceDesk)serviceDesk)).yield((user, project, serviceDesk, consistencyData) -> consistencyData);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private Response convertErrorCollectionToResponse(String reasonKey2, ErrorCollection errorCollection) {
        return this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build());
    }
}

