/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.agentview;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.NamedErrors;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.GoalResource;
import com.atlassian.servicedesk.internal.rest.sla.request.GoalRequest;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/agent/sla/metric/goal/validate")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServiceDeskSlaGoalResource {
    private final UserFactory userFactory;
    private final GoalService goalService;
    private final RestResponseHelper restResponseHelper;

    public ServiceDeskSlaGoalResource(UserFactory userFactory, GoalService goalService, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.goalService = goalService;
        this.restResponseHelper = restResponseHelper;
    }

    @PUT
    public Response updateMetrics(GoalRequest request) {
        Goal goal = GoalResource.fromRequest(request);
        return (Response)this.userFactory.getCheckedUser().fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), user -> (Response)this.goalService.validateGoal(user.forJIRA(), goal).fold(errorCollection -> this.toErrorResponse("Goal validation failed", (ErrorCollection)errorCollection), unit -> this.restResponseHelper.noContent()));
    }

    private Response toErrorResponse(String reason, ErrorCollection errorCollection) {
        if (errorCollection.getErrors().isEmpty()) {
            return this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reason).build());
        }
        Map<String, ErrorMessage> errors = errorCollection.getErrors().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ErrorMessage.builder().message((String)entry.getValue()).build()));
        NamedErrors namedErrors = new NamedErrors(errors, Response.Status.BAD_REQUEST.getStatusCode(), new ErrorCode(reason));
        return this.restResponseHelper.namedErrorsToResponse(namedErrors);
    }
}

