/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.admin.response;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugSLAValue;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class AdminSlaReconstructionResult {
    @JsonProperty
    @TenantAware(value=TenancyScope.TENANTED)
    public Map<String, Collection<DebugSLAValue>> successes;
    @JsonProperty
    @TenantAware(value=TenancyScope.TENANTED)
    public Map<String, Collection<String>> failures;

    public static AdminSlaReconstructionResult from(Map<String, Either<ErrorCollection, Collection<DebugSLAValue>>> results) {
        AdminSlaReconstructionResult adminSlaReconstructionResult = new AdminSlaReconstructionResult();
        adminSlaReconstructionResult.failures = Maps.transformValues((Map)Maps.filterValues(results, Either::isLeft), input -> ((ErrorCollection)input.left().get()).getErrorMessages());
        adminSlaReconstructionResult.successes = Maps.transformValues((Map)Maps.filterValues(results, Either::isRight), input -> (Collection)input.right().get());
        return adminSlaReconstructionResult;
    }
}

