/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorBuilder;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetricService;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.request.SlaThresholdRequest;
import com.atlassian.servicedesk.internal.rest.sla.response.SlaThresholdConfigurationResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.SlaThresholdsConfigurationResponse;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdService;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/sla/metric/{metricId}/threshold")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimeMetricSlaThresholdResource {
    private final SlaThresholdService slaThresholdService;
    private final ServiceDeskService serviceDeskService;
    private final TimeMetricService timeMetricService;
    private final ProjectService projectService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;

    protected TimeMetricSlaThresholdResource(SlaThresholdService slaThresholdService, ServiceDeskService serviceDeskService, TimeMetricService timeMetricService, ProjectService projectService, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper, UserFactory userFactory) {
        this.slaThresholdService = slaThresholdService;
        this.serviceDeskService = serviceDeskService;
        this.timeMetricService = timeMetricService;
        this.projectService = projectService;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
    }

    @GET
    @Path(value="/")
    public Response getThresholds(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") Long metricId) {
        io.atlassian.fugue.Either result = Steps.begin(this.getTimeMetric(projectKey, metricId)).then(timeMetric -> this.slaThresholdService.getThresholds(this.userFactory.getUncheckedUser().forJIRA(), (TimeMetric)timeMetric)).yield((timeMetric, slaThresholds) -> this.from((List<SlaThreshold>)slaThresholds));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="/")
    public Response addThreshold(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") Long metricId, SlaThresholdRequest slaThresholdRequest) {
        io.atlassian.fugue.Either result = Steps.begin(this.getTimeMetric(projectKey, metricId)).then(timeMetric -> this.slaThresholdService.addThreshold(this.userFactory.getUncheckedUser().forJIRA(), (TimeMetric)timeMetric, slaThresholdRequest.remainingTime)).yield((timeMetric, slaThresholds) -> this.from((List<SlaThreshold>)slaThresholds));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @DELETE
    @Path(value="/")
    public Response removeThreshold(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") Long metricId, SlaThresholdRequest slaThresholdRequest) {
        io.atlassian.fugue.Either result = Steps.begin(this.getTimeMetric(projectKey, metricId)).then(timeMetric -> this.slaThresholdService.removeThreshold(this.userFactory.getUncheckedUser().forJIRA(), (TimeMetric)timeMetric, slaThresholdRequest.remainingTime)).yield((timeMetric, slaThresholds) -> this.from((List<SlaThreshold>)slaThresholds));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, TimeMetric> getTimeMetric(String projectKey, Long metricId) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        if (metricId == null) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user.forJIRA(), HttpStatusCode.NOT_FOUND, "sd.sla.threshold.error.time.metric.id.missing", new Object[0]));
        }
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user.forJIRA(), projectKey);
        if (!projectResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)ErrorBuilder.errorBuilder().addError((String)projectResult.getErrorCollection().getErrorMessages().iterator().next()).httpStatusCode(HttpStatusCode.NOT_FOUND).buildSingleError());
        }
        io.atlassian.fugue.Either serviceDeskResult = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), projectResult.getProject()));
        if (serviceDeskResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)serviceDeskResult.left().get());
        }
        return StepsConverters.newerEither((Either)this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDeskResult.right().get(), metricId.intValue()));
    }

    private SlaThresholdsConfigurationResponse from(List<SlaThreshold> slaThresholds) {
        SlaThresholdsConfigurationResponse response = new SlaThresholdsConfigurationResponse();
        response.thresholds.addAll(slaThresholds.stream().map(this::from).collect(Collectors.toList()));
        return response;
    }

    private SlaThresholdConfigurationResponse from(SlaThreshold slaThreshold) {
        SlaThresholdConfigurationResponse response = new SlaThresholdConfigurationResponse();
        response.remainingTime = slaThreshold.getRemainingTime();
        return response;
    }
}

