/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.request.TimeMetricRequest;
import com.atlassian.servicedesk.internal.rest.sla.response.ThresholdResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricWhenResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricsResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricsWhenResponse;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricCreationService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdService;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevel;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevelService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/sla/metric")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimeMetricResource {
    private final InternalTimeMetricService timeMetricService;
    private final SlaThresholdService slaThresholdService;
    private final UrgencyLevelService urgencyLevelService;
    private final TimeMetricCreationService timeMetricCreationService;
    private final InternalServiceDeskService serviceDeskService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;

    protected TimeMetricResource(InternalTimeMetricService timeMetricService, TimeMetricCreationService timeMetricCreationService, InternalServiceDeskService serviceDeskService, SlaThresholdService slaThresholdService, UrgencyLevelService urgencyLevelService, UserFactory userFactory, RestResponseHelper restResponseHelper) {
        this.timeMetricService = timeMetricService;
        this.timeMetricCreationService = timeMetricCreationService;
        this.serviceDeskService = serviceDeskService;
        this.slaThresholdService = slaThresholdService;
        this.urgencyLevelService = urgencyLevelService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="/{metricId}")
    public Response getTimeMetric(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") Long metricId) {
        if (metricId == null) {
            return this.restResponseHelper.badRequest("metricId parameter is required");
        }
        UncheckedUser user = this.userFactory.getUncheckedUser();
        return (Response)this.getServiceDesk(projectKey).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), serviceDesk -> (Response)this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId.intValue()).fold(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey("Cannot get time metric").build()), timeMetric -> this.restResponseHelper.ok((Object)this.from((TimeMetric)((Object)((Object)timeMetric))))));
    }

    @GET
    @Path(value="/all")
    public Response getAllTimeMetrics(@PathParam(value="projectKey") String projectKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        return this.restResponseHelper.anErrorEitherToOkResponse(this.getServiceDesk(projectKey).map(serviceDesk -> this.from(this.timeMetricService.getTimeMetrics(user.forJIRA(), (ServiceDesk)serviceDesk))));
    }

    @GET
    @Path(value="/all/when-handler")
    public Response getAllTimeMetricsForWhenHandler(@PathParam(value="projectKey") String projectKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        return this.restResponseHelper.anErrorEitherToOkResponse(this.getServiceDesk(projectKey).map(serviceDesk -> this.whenFrom((SDUser)user, this.timeMetricService.getTimeMetrics(user.forJIRA(), (ServiceDesk)serviceDesk))));
    }

    @POST
    public Response createTimeMetric(TimeMetricRequest timeMetricRequest, @PathParam(value="projectKey") String projectKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        return (Response)this.getServiceDesk(projectKey).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), serviceDesk -> (Response)this.createTimeMetricFromRequest(user.forJIRA(), timeMetricRequest, (ServiceDesk)serviceDesk).fold(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey("Unable to create time metric").build()), timeMetric -> this.restResponseHelper.ok((Object)this.from((TimeMetric)((Object)((Object)timeMetric))))));
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeMetricFromRequest(ApplicationUser user, TimeMetricRequest timeMetricRequest, ServiceDesk serviceDesk) {
        String fieldName = timeMetricRequest.customFieldName;
        Long fieldId = timeMetricRequest.customFieldId;
        String metricName = timeMetricRequest.metricName;
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetric = fieldName != null ? this.timeMetricCreationService.createTimeMetric(user, serviceDesk, metricName, fieldName) : this.timeMetricCreationService.createTimeMetric(user, serviceDesk, metricName, fieldId);
        return timeMetric;
    }

    private TimeMetricResponse from(TimeMetric timeMetric) {
        TimeMetricResponse response = new TimeMetricResponse();
        response.id = timeMetric.getId();
        response.name = timeMetric.getName();
        response.customFieldId = timeMetric.getCustomFieldId();
        return response;
    }

    private TimeMetricsResponse from(List<TimeMetric> timeMetrics) {
        TimeMetricsResponse response = new TimeMetricsResponse();
        response.metrics.addAll(timeMetrics.stream().map(this::from).collect(Collectors.toList()));
        return response;
    }

    private TimeMetricsWhenResponse whenFrom(SDUser user, List<TimeMetric> timeMetrics) {
        ArrayList timeMetricWhenResponses = Lists.newArrayList();
        for (TimeMetric tm : timeMetrics) {
            List thresholds = (List)this.slaThresholdService.getThresholds(this.userFactory.getUncheckedUser().forJIRA(), tm).right().getOrElse((Object)Lists.newArrayList());
            timeMetricWhenResponses.add(this.from(user, tm, thresholds));
        }
        TimeMetricsWhenResponse response = new TimeMetricsWhenResponse();
        response.metrics = timeMetricWhenResponses;
        return response;
    }

    private TimeMetricWhenResponse from(SDUser user, TimeMetric timeMetric, List<SlaThreshold> thresholds) {
        List thresholdResponses = thresholds.stream().map(t -> this.from(user, (SlaThreshold)t)).collect(Collectors.toList());
        TimeMetricWhenResponse response = new TimeMetricWhenResponse();
        response.id = timeMetric.getId();
        response.name = timeMetric.getName();
        response.customFieldId = timeMetric.getCustomFieldId();
        response.thresholds = thresholdResponses;
        return response;
    }

    private ThresholdResponse from(SDUser user, SlaThreshold threshold) {
        I18nHelper i18nHelper = user.i18NHelper();
        ThresholdResponse response = new ThresholdResponse();
        response.timeRemaining = threshold.getRemainingTime();
        for (UrgencyLevel ul : this.urgencyLevelService.getUrgencyLevelForRemainingTime(threshold.getRemainingTime())) {
            response.label = i18nHelper.getText(ul.getKey());
        }
        return response;
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> getServiceDesk(String projectKey) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false)).yield((checkedUser, serviceDesk) -> serviceDesk);
    }
}

