/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.request.MetricConditionRequest;
import com.atlassian.servicedesk.internal.rest.sla.request.TimeMetricDefinitionRequest;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricDefinitionEntry;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricDefinitionResponse;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricHitConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricMatchConditionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionService;
import com.atlassian.servicedesk.internal.sla.configuration.condition.ConditionType;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/sla/metric/{metricId}/definition")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimeMetricDefinitionResource {
    private final MetricConditionRefService metricConditionRefService;
    private final InternalTimeMetricService timeMetricService;
    private final TimeMetricDefinitionService timeMetricDefinitionService;
    private final UserFactory userFactory;
    private final InternalServiceDeskService serviceDeskService;
    private final RestResponseHelper restResponseHelper;

    public TimeMetricDefinitionResource(MetricConditionRefService metricConditionRefService, InternalServiceDeskService serviceDeskService, InternalTimeMetricService timeMetricService, TimeMetricDefinitionService timeMetricDefinitionService, UserFactory userFactory, RestResponseHelper restResponseHelper) {
        this.metricConditionRefService = metricConditionRefService;
        this.timeMetricService = timeMetricService;
        this.timeMetricDefinitionService = timeMetricDefinitionService;
        this.serviceDeskService = serviceDeskService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response get(@PathParam(value="metricId") Long metricId, @PathParam(value="projectKey") String projectKey) {
        if (metricId == null) {
            return this.restResponseHelper.badRequest("Cannot get metric conditions without a metric id");
        }
        UncheckedUser user = this.userFactory.getUncheckedUser();
        return (Response)this.getServiceDesk(projectKey).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), serviceDesk -> (Response)this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId.intValue()).fold(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey("Cannot get metric conditions").build()), timeMetric -> {
            TimeMetricDefinitionInfo timeMetricDefinition = this.timeMetricDefinitionService.loadDefinitionConfiguration(user.forJIRA(), (TimeMetric)((Object)((Object)timeMetric)));
            return this.restResponseHelper.ok((Object)TimeMetricDefinitionResource.from(user.i18NHelper(), timeMetricDefinition));
        }));
    }

    @POST
    public Response addCondition(MetricConditionRequest request, @PathParam(value="metricId") Long metricId, @PathParam(value="projectKey") String projectKey) {
        if (metricId == null) {
            return this.restResponseHelper.badRequest("Cannot add a condition without a metric id");
        }
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapAnErrorResponse(this.getServiceDesk(projectKey))).then(serviceDesk -> this.leftMapErrorCollectionResponse("Cannot add condition, cause couldn't retrieve the associated Time Metric", this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId.intValue()))).then((serviceDesk, timeMetric) -> this.getAndValidateConditionType(request.type)).then((serviceDesk, timeMetric, conditionType) -> this.leftMapErrorCollectionResponse("Cannot remove condition", this.metricConditionRefService.addCondition(user.forJIRA(), (ServiceDesk)serviceDesk, (TimeMetric)((Object)timeMetric), this.buildMetricConditionRef(request, (ConditionType)((Object)conditionType))))).yield((serviceDesk, timeMetric, conditionType, metricConditionRef) -> this.from((MetricConditionRef)((Object)metricConditionRef)));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.map(arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0)));
    }

    @DELETE
    public Response removeCondition(MetricConditionRequest request, @PathParam(value="metricId") Long metricId, @PathParam(value="projectKey") String projectKey) {
        if (metricId == null) {
            return this.restResponseHelper.badRequest("Cannot remove a condition without a metric id");
        }
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapAnErrorResponse(this.getServiceDesk(projectKey))).then(serviceDesk -> this.leftMapErrorCollectionResponse("Cannot remove condition", this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId.intValue()))).then((serviceDesk, timeMetric) -> this.getAndValidateConditionType(request.type)).then((serviceDesk, timeMetric, conditionType) -> this.leftMapErrorCollectionResponse("Cannot add condition", this.metricConditionRefService.removeCondition(user.forJIRA(), (ServiceDesk)serviceDesk, (TimeMetric)((Object)timeMetric), this.buildMetricConditionRef(request, (ConditionType)((Object)conditionType))))).yield((serviceDesk, timeMetric, conditionType, nothing) -> Unit.Unit());
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.map(unit -> Response.noContent().build()));
    }

    @PUT
    public Response update(@PathParam(value="metricId") Long metricId, @PathParam(value="projectKey") String projectKey, TimeMetricDefinitionRequest request) {
        if (metricId == null) {
            return this.restResponseHelper.badRequest("Couldn't update conditions without a metric id");
        }
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapAnErrorResponse(this.getServiceDesk(projectKey))).then(serviceDesk -> this.leftMapErrorCollectionResponse("Couldn't update conditions, cause couldn't retrieve the associated Time Metric", this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId.intValue()))).then((serviceDesk, timeMetric) -> this.leftMapErrorCollectionResponse("Couldn't update conditions", this.timeMetricDefinitionService.updateDefinitionConfiguration(user.forJIRA(), (ServiceDesk)serviceDesk, (TimeMetric)((Object)timeMetric), TimeMetricDefinitionResource.from(request)))).yield((serviceDesk, timeMetric, timeMetricDefinitionInfo) -> TimeMetricDefinitionResource.from(user.i18NHelper(), timeMetricDefinitionInfo));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.map(arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0)));
    }

    private MetricConditionRef buildMetricConditionRef(MetricConditionRequest request, ConditionType conditionType) {
        return new MetricConditionRef.MetricConditionBuilder().pluginKey(request.pluginKey).factoryKey(request.factoryKey).conditionId(request.conditionId).type(conditionType).build();
    }

    public static TimeMetricDefinitionResponse from(I18nHelper helper, TimeMetricDefinitionInfo timeMetricDefinition) {
        TimeMetricDefinitionResponse response = new TimeMetricDefinitionResponse();
        for (TimeMetricConditionInfo condition : timeMetricDefinition.getStartConditions()) {
            TimeMetricDefinitionEntry startEntry = TimeMetricDefinitionResource.from(helper, condition, ConditionType.START.getName());
            response.inconsistent = response.inconsistent || startEntry.missing;
            response.start.add(startEntry);
        }
        for (TimeMetricConditionInfo condition : timeMetricDefinition.getPauseConditions()) {
            TimeMetricDefinitionEntry pauseEntry = TimeMetricDefinitionResource.from(helper, (TimeMetricMatchConditionInfo)condition, ConditionType.PAUSE.getName());
            response.inconsistent = response.inconsistent || pauseEntry.missing;
            response.pause.add(pauseEntry);
        }
        for (TimeMetricConditionInfo condition : timeMetricDefinition.getStopConditions()) {
            TimeMetricDefinitionEntry stopEntry = TimeMetricDefinitionResource.from(helper, condition, ConditionType.STOP.getName());
            response.inconsistent = response.inconsistent || stopEntry.missing;
            response.stop.add(stopEntry);
        }
        TimeMetricDefinitionEntryComparator comparator = new TimeMetricDefinitionEntryComparator();
        Collections.sort(response.start, comparator);
        Collections.sort(response.pause, comparator);
        Collections.sort(response.stop, comparator);
        return response;
    }

    public static TimeMetricDefinitionEntry from(I18nHelper helper, TimeMetricHitConditionInfo condition, String conditionType) {
        TimeMetricDefinitionEntry result = TimeMetricDefinitionResource.getBaseEntry(condition, conditionType);
        if (condition.isComplete()) {
            result.name = ((TimeMetricHitCondition)condition.getCondition()).getName(helper);
            result.missing = false;
        } else {
            result.name = result.pluginKey + ":" + result.factoryKey + ":" + result.conditionId;
            result.missing = true;
        }
        return result;
    }

    public static TimeMetricDefinitionEntry from(I18nHelper helper, TimeMetricMatchConditionInfo condition, String conditionType) {
        TimeMetricDefinitionEntry result = TimeMetricDefinitionResource.getBaseEntry(condition, conditionType);
        if (condition.isComplete()) {
            result.name = ((TimeMetricMatchCondition)condition.getCondition()).getName(helper);
            result.missing = false;
        } else {
            result.name = result.pluginKey + ":" + result.factoryKey + ":" + result.conditionId;
            result.missing = true;
        }
        return result;
    }

    private static TimeMetricDefinitionEntry getBaseEntry(TimeMetricConditionInfo condition, String conditionType) {
        TimeMetricDefinitionEntry result = new TimeMetricDefinitionEntry();
        result.pluginKey = condition.getPluginKey();
        result.factoryKey = condition.getConditionFactoryKey();
        result.conditionId = condition.getConditionId();
        result.type = conditionType;
        return result;
    }

    private TimeMetricDefinitionEntry from(MetricConditionRef condition) {
        TimeMetricDefinitionEntry result = new TimeMetricDefinitionEntry();
        result.pluginKey = condition.getPluginKey();
        result.factoryKey = condition.getFactoryKey();
        result.conditionId = condition.getConditionId();
        result.type = condition.getType().toString();
        return result;
    }

    public static TimeMetricDefinitionInfo from(TimeMetricDefinitionRequest definition) {
        HashSet start = Sets.newHashSet();
        for (TimeMetricDefinitionEntry timeMetricDefinitionEntry : definition.start) {
            TimeMetricHitConditionInfo timeMetricConditionInfo = new TimeMetricHitConditionInfo(timeMetricDefinitionEntry.pluginKey, timeMetricDefinitionEntry.factoryKey, timeMetricDefinitionEntry.conditionId, (Option<TimeMetricHitCondition>)Option.none());
            start.add(timeMetricConditionInfo);
        }
        HashSet pause = Sets.newHashSet();
        for (TimeMetricDefinitionEntry conditionEntry : definition.pause) {
            TimeMetricMatchConditionInfo timeMetricConditionInfo = new TimeMetricMatchConditionInfo(conditionEntry.pluginKey, conditionEntry.factoryKey, conditionEntry.conditionId, (Option<TimeMetricMatchCondition>)Option.none());
            pause.add(timeMetricConditionInfo);
        }
        HashSet hashSet = Sets.newHashSet();
        for (TimeMetricDefinitionEntry conditionEntry : definition.stop) {
            TimeMetricHitConditionInfo timeMetricConditionInfo = new TimeMetricHitConditionInfo(conditionEntry.pluginKey, conditionEntry.factoryKey, conditionEntry.conditionId, (Option<TimeMetricHitCondition>)Option.none());
            hashSet.add(timeMetricConditionInfo);
        }
        return new TimeMetricDefinitionInfo(start, pause, hashSet);
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> getServiceDesk(String projectKey) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false)).yield((checkedUser, serviceDesk) -> serviceDesk);
    }

    private io.atlassian.fugue.Either<Response, ConditionType> getAndValidateConditionType(String type) {
        ConditionType conditionType = ConditionType.byName(type);
        if (conditionType == null) {
            return io.atlassian.fugue.Either.left((Object)this.restResponseHelper.badRequest("Cannot add condition because of invalid condition type"));
        }
        return io.atlassian.fugue.Either.right((Object)((Object)conditionType));
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapAnErrorResponse(io.atlassian.fugue.Either<AnError, T> either) {
        return either.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0));
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapErrorCollectionResponse(String reasonKey2, io.atlassian.fugue.Either<ErrorCollection, T> either) {
        return either.leftMap(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build()));
    }

    private static class TimeMetricDefinitionEntryComparator
    implements Comparator<TimeMetricDefinitionEntry> {
        private TimeMetricDefinitionEntryComparator() {
        }

        @Override
        public int compare(TimeMetricDefinitionEntry a, TimeMetricDefinitionEntry b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            if (a.name == null && b.name == null) {
                return 0;
            }
            if (a.name == null) {
                return 1;
            }
            if (b.name == null) {
                return -1;
            }
            return a.name.compareToIgnoreCase(b.name);
        }
    }
}

