/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.request.SlaThresholdRequest;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdService;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/sla/threshold")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SlaThresholdResource {
    private final SlaThresholdService slaThresholdService;
    private final ServiceDeskService serviceDeskService;
    private final ProjectService projectService;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;

    protected SlaThresholdResource(SlaThresholdService slaThresholdService, ServiceDeskService serviceDeskService, ProjectService projectService, RestResponseHelper restResponseHelper, UserFactory userFactory) {
        this.slaThresholdService = slaThresholdService;
        this.serviceDeskService = serviceDeskService;
        this.projectService = projectService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
    }

    @POST
    @Path(value="/")
    public Response addThresholdForAllTimeMetrics(@PathParam(value="projectKey") String projectKey, SlaThresholdRequest slaThresholdRequest) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user.forJIRA(), projectKey);
        if (!projectResult.isValid()) {
            return this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)projectResult.getErrorCollection()).reasonKey("sd.sla.threshold.error.project.not.found").build());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), projectResult.getProject()))).then(serviceDesk -> this.slaThresholdService.addThresholdForAllTimeMetrics(user.forJIRA(), (ServiceDesk)serviceDesk, slaThresholdRequest.remainingTime)).yield((serviceDesk, unit) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }

    @DELETE
    @Path(value="/")
    public Response removeThresholdForAllTimeMetrics(@PathParam(value="projectKey") String projectKey, SlaThresholdRequest slaThresholdRequest) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user.forJIRA(), projectKey);
        if (!projectResult.isValid()) {
            return this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)projectResult.getErrorCollection()).reasonKey("sd.sla.threshold.error.project.not.found").build());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), projectResult.getProject()))).then(serviceDesk -> this.slaThresholdService.removeThresholdForAllTimeMetrics(user.forJIRA(), (ServiceDesk)serviceDesk, slaThresholdRequest.remainingTime)).yield((serviceDesk, unit) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }
}

