/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldService;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.request.SLAFieldRequest;
import com.atlassian.servicedesk.internal.rest.sla.response.ProjectAdminFieldCreationResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.SLAFieldResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.SLAFieldsResponse;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/sla/field")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SLAFieldResource {
    private final SLAFieldService slaFieldService;
    private final CustomFieldService customFieldService;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;

    public SLAFieldResource(SLAFieldService slaFieldService, CustomFieldService customFieldService, RestResponseHelper restResponseHelper, UserFactory userFactory) {
        this.slaFieldService = slaFieldService;
        this.customFieldService = customFieldService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
    }

    @POST
    public Response createSLAField(SLAFieldRequest request) {
        String fieldName = request.name;
        if (fieldName == null || fieldName.length() == 0) {
            return this.restResponseHelper.badRequest("fieldName must be specified");
        }
        Either bimap = this.slaFieldService.createSLAField(this.userFactory.getUncheckedUser().forJIRA(), fieldName).bimap(errorCollection -> this.fromErrorCollection("Errors creating the SLA field '" + fieldName + "'", (ErrorCollection)errorCollection), this::from);
        return this.restResponseHelper.validationErrorsEitherToOkResponse(bimap);
    }

    @GET
    @Path(value="/all")
    public Response getAll() {
        Either bimap = this.slaFieldService.getAll(this.userFactory.getUncheckedUser().forJIRA()).bimap(errorCollection -> this.fromErrorCollection("Error retrieving SLA fields list", (ErrorCollection)errorCollection), this::from);
        return this.restResponseHelper.validationErrorsEitherToOkResponse(bimap);
    }

    @GET
    @Path(value="/all/unused")
    public Response getAllUnused() {
        return this.restResponseHelper.validationErrorsEitherToOkResponse(this.slaFieldService.getAllUnusedFields(this.userFactory.getUncheckedUser().forJIRA()).bimap(errorCollection -> this.fromErrorCollection("Error retrieving SLA fields list", (ErrorCollection)errorCollection), this::from));
    }

    @DELETE
    @Path(value="/all/unused")
    public Response deleteUnusedSLAFields() {
        Either bimap = this.slaFieldService.deleteUnusedSLAFields(this.userFactory.getUncheckedUser().forJIRA()).bimap(errorCollection -> this.fromErrorCollection("Error deleting unused SLA fields", (ErrorCollection)errorCollection), unit -> this.getAllUnused());
        return (Response)Eithers.merge((Either)bimap.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).validationErrorsToResponse(arg_0)));
    }

    @DELETE
    @Path(value="/{fieldId}")
    public Response deleteSLAField(@PathParam(value="fieldId") Long fieldId) {
        if (fieldId == null) {
            return this.restResponseHelper.badRequest("fieldId must be specified");
        }
        CustomField slaField = this.customFieldService.getCustomField(fieldId);
        if (slaField == null) {
            return this.restResponseHelper.badRequest("Field with given id does not exist");
        }
        Either bimap = this.slaFieldService.deleteSLAField(this.userFactory.getUncheckedUser().forJIRA(), slaField).leftMap(errorCollection -> this.fromErrorCollection("Error deleting SLA field", (ErrorCollection)errorCollection));
        return this.restResponseHelper.validationErrorsEitherToNoContentResponse(bimap);
    }

    @GET
    @Path(value="/projectAdminFieldCreationEnabled")
    public Response canProjectAdminCreateSlaFields() {
        ProjectAdminFieldCreationResponse response = new ProjectAdminFieldCreationResponse();
        response.projectAdminFieldCreationEnabled = this.slaFieldService.isProjectAdminFieldCreationEnabled();
        return this.restResponseHelper.ok((Object)response);
    }

    @PUT
    @Path(value="/projectAdminFieldCreationEnabled")
    public Response setProjectAdminFieldCreationEnabled() {
        return this.setProjectAdminFieldCreationEnabledSetting(true);
    }

    @DELETE
    @Path(value="/projectAdminFieldCreationEnabled")
    public Response setProjectAdminFieldCreationDisabled() {
        return this.setProjectAdminFieldCreationEnabledSetting(false);
    }

    private Response setProjectAdminFieldCreationEnabledSetting(boolean enabled) {
        return (Response)Eithers.merge((Either)this.slaFieldService.setProjectAdminFieldCreationEnabled(this.userFactory.getUncheckedUser().forJIRA(), enabled).bimap(errorCollection -> this.restResponseHelper.validationErrorsToResponse(this.fromErrorCollection("unable to set setting", (ErrorCollection)errorCollection)), unit -> this.canProjectAdminCreateSlaFields()));
    }

    private SLAFieldResponse from(CustomField customField) {
        SLAFieldResponse result = new SLAFieldResponse();
        result.id = customField.getIdAsLong();
        result.name = customField.getName();
        return result;
    }

    private SLAFieldsResponse from(List<CustomField> customFields) {
        SLAFieldsResponse response = new SLAFieldsResponse();
        for (CustomField slaField : customFields) {
            response.fields.add(this.from(slaField));
        }
        return response;
    }

    private ValidationErrors fromErrorCollection(String reasonKey2, ErrorCollection errorCollection) {
        return ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build();
    }
}

