/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.settings.requestsecurity;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.GlobalPublicSignupService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsUpdateBuilder;
import com.atlassian.servicedesk.internal.rest.settings.requestsecurity.RequestSecuritySettingsDataProvider;
import com.atlassian.servicedesk.internal.rest.settings.requestsecurity.RequestSecuritySettingsRequest;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsConfiguration;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsUpdate;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{projectKey}/settings/requestsecurity")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RequestSecuritySettingsResource {
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final RequestSecuritySettingsDataProvider requestSecuritySettingsDataProvider;
    private final InternalServiceDeskService serviceDeskService;
    private final ParticipantSettingsService participantSettingsService;
    private final GlobalPublicSignupService globalPublicSignupService;
    private final RestResponseHelper restResponseHelper;

    public RequestSecuritySettingsResource(UserFactory userFactory, ServiceDeskProjectService serviceDeskProjectService, RequestSecuritySettingsDataProvider requestSecuritySettingsDataProvider, InternalServiceDeskService serviceDeskService, ParticipantSettingsService participantSettingsService, GlobalPublicSignupService globalPublicSignupService, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.requestSecuritySettingsDataProvider = requestSecuritySettingsDataProvider;
        this.serviceDeskService = serviceDeskService;
        this.participantSettingsService = participantSettingsService;
        this.globalPublicSignupService = globalPublicSignupService;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response getRequestSecuritySettings(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.requestSecuritySettingsDataProvider::getData).yield((user, project, requestSecuritySettingsResponse) -> requestSecuritySettingsResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    public Response updateRequestSecuritySettings(@PathParam(value="projectKey") String projectKey, RequestSecuritySettingsRequest request) {
        boolean isOpenAccess = request.isServiceDeskOpenAccess();
        boolean isPublicSignup2 = request.isServiceDeskPublicSignup();
        boolean isManageEnabled = request.isManageEnabled();
        boolean isAutocompleteEnabled = request.isAutocompleteEnabled();
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.updateParticipantSettings((CheckedUser)user, (Project)project, isManageEnabled, isAutocompleteEnabled)).then((user, project, participantConfig) -> this.updateAccessConfig((CheckedUser)user, (Project)project, isOpenAccess, isPublicSignup2)).then((user, project, participantConfig, success) -> this.requestSecuritySettingsDataProvider.getData((CheckedUser)user, (Project)project)).yield((user, project, participantConfig, success, response) -> response);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, ParticipantSettingsConfiguration> updateParticipantSettings(CheckedUser user, Project project, boolean isManageEnabled, boolean isAutocompleteEnabled) {
        return Steps.begin((io.atlassian.fugue.Either)this.serviceDeskService.getServiceDeskForProject(user, project, false)).then(serviceDesk -> {
            ParticipantSettingsUpdate participantSettingsUpdate = new ParticipantSettingsUpdateBuilder((ServiceDesk)serviceDesk).setManageEnabled(isManageEnabled).setAutocompleteEnabled(isAutocompleteEnabled).build();
            return this.participantSettingsService.updateSettings(user, project, participantSettingsUpdate);
        }).yield((serviceDesk, participantConfig) -> participantConfig);
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> updateAccessConfig(CheckedUser user, Project project, boolean isOpenAccess, boolean isPublicSignup2) {
        io.atlassian.fugue.Either<AnError, Boolean> globalSignupResult;
        if (isPublicSignup2 && !this.globalPublicSignupService.isGlobalPublicSignupEnabled() && (globalSignupResult = this.globalPublicSignupService.setGlobalPublicSignup(user, true)).isLeft()) {
            return globalSignupResult.map(ignore -> JSDSuccess.success());
        }
        return this.serviceDeskService.updateAccessConfig(user, project, isOpenAccess, isPublicSignup2).map(ignored -> JSDSuccess.success());
    }
}

