/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses.emailsettings;

import com.atlassian.jira.mail.processor.api.channel.ChannelDefinition;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class EmailSettingResponse {
    private final int id;
    private final String emailAddress;
    private final Integer requestTypeId;
    private final String requestTypeName;
    private final Long requestTypeIcon;
    private final Boolean enabled;
    private final Boolean onDemand;
    private final String username;
    private final String protocol;
    private final String host;
    private final String port;
    private final Boolean broken;

    private EmailSettingResponse(int id, String emailAddress, Integer requestTypeId, String requestTypeName, Long requestTypeIcon, Boolean enabled, Boolean onDemand, String username, String protocol, String host, String port, Boolean broken) {
        this.id = id;
        this.emailAddress = emailAddress;
        this.requestTypeId = requestTypeId;
        this.requestTypeName = requestTypeName;
        this.requestTypeIcon = requestTypeIcon;
        this.enabled = enabled;
        this.onDemand = onDemand;
        this.username = username;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.broken = broken;
    }

    public int getId() {
        return this.id;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Integer getRequestTypeId() {
        return this.requestTypeId;
    }

    public String getRequestTypeName() {
        return this.requestTypeName;
    }

    public Long getRequestTypeIcon() {
        return this.requestTypeIcon;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getOnDemand() {
        return this.onDemand;
    }

    public String getUsername() {
        return this.username;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public Boolean getBroken() {
        return this.broken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int id;
        private String emailAddress;
        private Integer requestTypeId;
        private String requestTypeName;
        private Long requestTypeIcon;
        private Boolean enabled;
        private Boolean onDemand;
        private String username;
        private String protocol;
        private String host;
        private String port;
        private Boolean broken;

        private Builder() {
        }

        public Builder setFromChannelSettings(EmailChannelSetting emailChannelSetting) {
            this.id = emailChannelSetting.getId();
            this.emailAddress = emailChannelSetting.getEmailAddress();
            this.onDemand = emailChannelSetting.isOnDemand();
            return this;
        }

        public Builder setFromRequestType(RequestType requestType) {
            this.requestTypeId = requestType.getId();
            this.requestTypeName = requestType.getName();
            this.requestTypeIcon = requestType.getIconId();
            return this;
        }

        public Builder setFromChannelDefenition(ChannelDefinition channelDefenition) {
            this.enabled = channelDefenition.isEnabled();
            this.username = channelDefenition.getChannelConnectionDefinition().getUserName();
            this.protocol = channelDefenition.getChannelConnectionDefinition().getProtocol();
            this.host = channelDefenition.getChannelConnectionDefinition().getHostName();
            this.port = Integer.toString(channelDefenition.getChannelConnectionDefinition().getPort());
            return this;
        }

        public Builder setBroken(Boolean broken) {
            this.broken = broken;
            return this;
        }

        public EmailSettingResponse build() {
            return new EmailSettingResponse(this.id, this.emailAddress, this.requestTypeId, this.requestTypeName, this.requestTypeIcon, this.enabled, this.onDemand, this.username, this.protocol, this.host, this.port, this.broken);
        }
    }
}

