/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses.emailsettings;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.internal.rest.responses.emailsettings.IncomingEmailRequestTypeResponse;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class EmailSettingDialogResponse {
    private final List<IncomingEmailRequestTypeResponse> requestTypes;
    private final List<IncomingEmailRequestTypeResponse> invalidRequestTypes;
    @TenantAware(value=TenancyScope.TENANTED)
    private final Map<String, PredefinedProtocol> predefinedProtocols;
    @TenantAware(value=TenancyScope.TENANTED)
    private final Map<String, PredefinedProvider> predefinedProviders;

    private EmailSettingDialogResponse(List<IncomingEmailRequestTypeResponse> requestTypes, List<IncomingEmailRequestTypeResponse> invalidRequestTypes, Map<String, PredefinedProtocol> predefinedProtocols, Map<String, PredefinedProvider> predefinedProviders) {
        this.requestTypes = requestTypes;
        this.invalidRequestTypes = invalidRequestTypes;
        this.predefinedProtocols = predefinedProtocols;
        this.predefinedProviders = predefinedProviders;
    }

    public List<IncomingEmailRequestTypeResponse> getRequestTypes() {
        return this.requestTypes;
    }

    public List<IncomingEmailRequestTypeResponse> getInvalidRequestTypes() {
        return this.invalidRequestTypes;
    }

    public Map<String, PredefinedProtocol> getPredefinedProtocols() {
        return this.predefinedProtocols;
    }

    public Map<String, PredefinedProvider> getPredefinedProviders() {
        return this.predefinedProviders;
    }

    public static EmailSettingDialogResponse build(List<IncomingEmailRequestTypeResponse> requestTypes, List<IncomingEmailRequestTypeResponse> invalidRequestTypes) {
        return new EmailSettingDialogResponse(requestTypes, invalidRequestTypes, PredefinedProtocol.PREDEFINED_PROTOCOLS, PredefinedProvider.PREDEFINED_PROVIDERS);
    }

    @JsonAutoDetect
    public static class PredefinedProvider {
        private static final String GMAIL_TEXT = "Gmail";
        private static final String GMAIL_HOST = "imap.gmail.com";
        private static final String GMAIL_PROTOCOL = "imaps";
        private static final String GMAIL_PORT = "993";
        private static final String YAHOO_TEXT = "Yahoo";
        private static final String YAHOO_HOST = "imap.mail.yahoo.com";
        private static final String YAHOO_PROTOCOL = "imaps";
        private static final String YAHOO_PORT = "993";
        @TenantAware(value=TenancyScope.TENANTLESS)
        private static final Map<String, PredefinedProvider> PREDEFINED_PROVIDERS = ImmutableMap.builder().put((Object)"gmail", (Object)new PredefinedProvider("Gmail", "imap.gmail.com", "imaps", "993")).put((Object)"yahoo", (Object)new PredefinedProvider("Yahoo", "imap.mail.yahoo.com", "imaps", "993")).build();
        private final String text;
        private final String host;
        private final String protocol;
        private final String port;

        private PredefinedProvider(String text, String host, String protocol, String port) {
            this.text = text;
            this.host = host;
            this.protocol = protocol;
            this.port = port;
        }

        public String getText() {
            return this.text;
        }

        public String getHost() {
            return this.host;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getPort() {
            return this.port;
        }
    }

    @JsonAutoDetect
    public static class PredefinedProtocol {
        private static final String POP3 = "pop3";
        private static final String POP3_TEXT = "POP";
        private static final String POP3_PORT = "110";
        private static final String POP3S = "pop3s";
        private static final String POP3S_TEXT = "SECURE POP";
        private static final String POP3S_PORT = "995";
        private static final String IMAP = "imap";
        private static final String IMAP_TEXT = "IMAP";
        private static final String IMAP_PORT = "143";
        private static final String IMAPS = "imaps";
        private static final String IMAPS_TEXT = "SECURE IMAP";
        private static final String IMAPS_PORT = "993";
        @TenantAware(value=TenancyScope.TENANTLESS)
        public static final Map<String, PredefinedProtocol> PREDEFINED_PROTOCOLS = ImmutableMap.builder().put((Object)"pop3", (Object)new PredefinedProtocol("POP", "110")).put((Object)"pop3s", (Object)new PredefinedProtocol("SECURE POP", "995")).put((Object)"imap", (Object)new PredefinedProtocol("IMAP", "143")).put((Object)"imaps", (Object)new PredefinedProtocol("SECURE IMAP", "993")).build();
        private final String text;
        private final String port;

        private PredefinedProtocol(String text, String port) {
            this.text = text;
            this.port = port;
        }

        public String getText() {
            return this.text;
        }

        public String getPort() {
            return this.port;
        }
    }
}

