/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses;

import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class RequestTypeBean {
    private String id;
    private String key;
    private String name;
    private String descriptionHtml;
    private String callToAction;
    private String introHtml;
    private Long icon;
    private List<Integer> groups;

    public RequestTypeBean() {
    }

    public RequestTypeBean(String id, String key, String name, String descriptionHtml, String callToAction, String introHtml, Long icon, List<Integer> groups) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.descriptionHtml = descriptionHtml;
        this.callToAction = callToAction;
        this.introHtml = introHtml;
        this.icon = icon;
        this.groups = groups;
    }

    public RequestTypeBean(RequestType requestType, String requestTypeKey, CheckedUser user, RichTextRenderer renderer) {
        this.id = String.valueOf(requestType.getId());
        this.key = requestTypeKey;
        this.name = requestType.getName();
        this.callToAction = requestType.getName();
        this.introHtml = renderer.renderCustomerWiki(requestType.getDescription(), (Option<CheckedUser>)Option.option((Object)user), RenderOption.OPEN_LINKS_IN_NEW_TAB);
        this.icon = requestType.getIconId();
        this.descriptionHtml = renderer.renderCustomerWiki(requestType.getHelpText(), (Option<CheckedUser>)Option.option((Object)user), RenderOption.OPEN_LINKS_IN_NEW_TAB);
        this.groups = requestType.getGroups().stream().map(group -> group.getId()).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptionHtml() {
        return this.descriptionHtml;
    }

    public String getCallToAction() {
        return this.callToAction;
    }

    public String getIntroHtml() {
        return this.introHtml;
    }

    public List<Integer> getGroups() {
        return this.groups;
    }

    public Long getIcon() {
        return this.icon;
    }
}

