/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses;

import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class AgentWorkloadDetails {
    public static final String BREACHED = "breached";
    public static final String URGENT = "urgent";
    public static final String NORMAL = "normal";
    private final long total;
    private final long breachedCount;
    private final long urgentCount;
    private final long normalCount;
    private final String jql;

    public AgentWorkloadDetails(long total, long breachedCount, long urgentCount, long normalCount, String jql) {
        this.total = total;
        this.breachedCount = breachedCount;
        this.urgentCount = urgentCount;
        this.normalCount = normalCount;
        this.jql = jql;
    }

    public long getTotal() {
        return this.total;
    }

    public long getBreachedCount() {
        return this.breachedCount;
    }

    public long getUrgentCount() {
        return this.urgentCount;
    }

    public long getNormalCount() {
        return this.normalCount;
    }

    public String getJql() {
        return this.jql;
    }

    public static AgentWorkloadDetails convertSeveritiesAndJQLToWorkloadObject(Map<String, Long> severityCountMap, String jql) {
        return new AgentWorkloadDetails(severityCountMap.values().stream().reduce(0L, Long::sum), severityCountMap.getOrDefault(BREACHED, 0L), severityCountMap.getOrDefault(URGENT, 0L), severityCountMap.getOrDefault(NORMAL, 0L), jql);
    }
}

