/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group.handler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeModificationService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.UpdateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.UpdateRequestTypeValidationResult;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeGroupDTO;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeUpdateRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeResponseHandler;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeUpdateRequestHandler {
    private final RequestTypeModificationService requestTypeModificationService;
    private final InternalPortalService internalPortalService;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final UserFactory userFactory;
    private final RequestTypeResponseHandler requestTypeResponseHandler;
    private final RestResponseHelper restResponseHelper;

    @Autowired
    public RequestTypeUpdateRequestHandler(RequestTypeModificationService requestTypeModificationService, InternalPortalService internalPortalService, ServiceDeskProjectService serviceDeskProjectService, UserFactory userFactory, RequestTypeResponseHandler requestTypeResponseHandler, RestResponseHelper restResponseHelper) {
        this.requestTypeModificationService = requestTypeModificationService;
        this.internalPortalService = internalPortalService;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.userFactory = userFactory;
        this.requestTypeResponseHandler = requestTypeResponseHandler;
        this.restResponseHelper = restResponseHelper;
    }

    public Response updateRequestType(Long projectId, Integer requestTypeId, RequestTypeUpdateRequest request) {
        return this.updateRequestTypeImpl(projectId, requestTypeId, request);
    }

    private Response updateRequestTypeImpl(Long projectId, int id, RequestTypeUpdateRequest request) {
        return (Response)this.performUpdateValidation(projectId, request).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), validationResult -> this.handleUpdateValidationResult(id, (UpdateRequestTypeValidationResult)validationResult, projectId));
    }

    public Response updateRequestTypeHelpText(Long projectId, int id, @Nonnull String helpText) {
        return (Response)this.requestTypeModificationService.updateRequestTypeHelpText(id, projectId, helpText).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestType -> this.requestTypeResponseHandler.requestType((RequestType)requestType, projectId));
    }

    private Response handleUpdateValidationResult(int id, UpdateRequestTypeValidationResult validationResult, long projectId) {
        if (validationResult.isValid()) {
            return (Response)this.requestTypeModificationService.updateRequestType(id, validationResult).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestType -> this.requestTypeResponseHandler.requestType((RequestType)requestType, projectId));
        }
        return this.restResponseHelper.namedErrorsToResponse(validationResult.getNamedErrors());
    }

    private io.atlassian.fugue.Either<AnError, UpdateRequestTypeValidationResult> performUpdateValidation(Long projectId, RequestTypeUpdateRequest request) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, projectId)).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeModificationService.validateUpdateRequestType(this.mapUpdateRequest(request), (Project)project)).yield((checkedUser, project, portal, validationResult) -> validationResult);
    }

    private UpdateRequestTypeParams mapUpdateRequest(RequestTypeUpdateRequest request) {
        return new UpdateRequestTypeParams(request.getIcon(), request.getName(), request.getDescription(), request.getOrder(), request.getGroups().stream().map(RequestTypeGroupDTO::getId).collect(Collectors.toList()));
    }
}

