/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group.handler;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.requests.RESTfulTableReorderRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeResponseHandler;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeMoveRequestHandler {
    private final RequestTypeResponseHandler requestTypeResponseHandler;
    private final RequestTypeInternalService requestTypeInternalService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;

    @Autowired
    public RequestTypeMoveRequestHandler(RequestTypeResponseHandler requestTypeResponseHandler, RequestTypeInternalService requestTypeInternalService, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper) {
        this.requestTypeResponseHandler = requestTypeResponseHandler;
        this.requestTypeInternalService = requestTypeInternalService;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
    }

    public Response reorderRequestTypes(long projectId, int groupId, int requestTypeId, RESTfulTableReorderRequest reorderRequest) {
        return (Response)Steps.begin(this.validateReorderRequest(reorderRequest)).then(beforeId -> this.requestTypeInternalService.moveRequestType(Integer.valueOf(requestTypeId), Long.valueOf(projectId), Integer.valueOf(groupId), beforeId)).yield((beforeId, requestType) -> requestType).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestType -> this.requestTypeResponseHandler.requestType((RequestType)requestType, projectId));
    }

    private Either<AnError, Option<Integer>> validateReorderRequest(RESTfulTableReorderRequest reorderRequest) {
        Option beforeId;
        if (StringUtils.isBlank((String)reorderRequest.getAfter()) && StringUtils.isBlank((String)reorderRequest.getPosition())) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.queue.general.error.invalidreorder", new Object[0]).build());
        }
        if (reorderRequest.getPosition() != null && reorderRequest.getPosition().equalsIgnoreCase("first")) {
            beforeId = Option.none();
        } else {
            String position = reorderRequest.getAfter();
            beforeId = Option.some((Object)Integer.valueOf(position.substring(position.lastIndexOf("/") + 1)));
        }
        return Either.right((Object)beforeId);
    }
}

