/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group.handler;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeGroupMappingHelper;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeGroupGetRequestHandler {
    private final RequestTypeGroupService groupService;
    private final UserFactory userFactory;
    private final PortalService portalService;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final RestResponseHelper restResponseHelper;

    @Autowired
    public RequestTypeGroupGetRequestHandler(RequestTypeGroupService groupService, UserFactory userFactory, PortalService portalService, ServiceDeskProjectService serviceDeskProjectService, RestResponseHelper restResponseHelper) {
        this.groupService = groupService;
        this.userFactory = userFactory;
        this.portalService = portalService;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.restResponseHelper = restResponseHelper;
    }

    public Response getGroupsForProject(long projectId) {
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, projectId)).then((checkedUser, project) -> StepsConverters.newerEither((Either)this.portalService.getPortalForProject(checkedUser.forJIRA(), project))).then((checkedUser, project, portal) -> this.groupService.getGroups(checkedUser.forJIRA(), project, portal)).yield((checkedUser, project, portal, groups) -> groups).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), groups -> Response.ok((Object)RequestTypeGroupMappingHelper.mapRequestTypeGroupListToDtoArray(groups)).build());
    }
}

