/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group;

import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.group.PartialRequestTypeGroup;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.rest.requests.RESTfulTableReorderRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.BulkUpdateRequestTypeGroupRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.CreateRequestTypeGroupRequestDTO;
import com.atlassian.servicedesk.internal.rest.requesttype.group.CreateRequestTypeGroupResponseDTO;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeCreateRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeGroupDTO;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeGroupMappingHelper;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeHelpTextUpdateRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeUpdateRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.UndoOperationsRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.UpdateRequestTypeGroupRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeCreateRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeDeleteRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeGetRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeGroupGetRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeMoveRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeUpdateRequestHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectId}/request-type-groups")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RequestTypeGroupResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final RequestTypeGroupService requestTypeGroupService;
    private final InternalPortalService internalPortalService;
    private final UserFactory userFactory;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final RequestTypeCreateRequestHandler requestTypeCreateRequestHandler;
    private final RequestTypeGetRequestHandler requestTypeGetRequestHandler;
    private final RequestTypeDeleteRequestHandler requestTypeDeleteRequestHandler;
    private final RequestTypeUpdateRequestHandler requestTypeUpdateRequestHandler;
    private final RequestTypeMoveRequestHandler requestTypeMoveRequestHandler;
    private final RequestTypeGroupGetRequestHandler requestTypeGroupGetRequestHandler;
    private final RestResponseHelper restResponseHelper;

    public RequestTypeGroupResource(JiraAuthenticationContext jiraAuthenticationContext, RequestTypeGroupService requestTypeGroupService, InternalPortalService internalPortalService, UserFactory userFactory, InternalServiceDeskProjectManager internalServiceDeskProjectManager, RequestTypeCreateRequestHandler requestTypeCreateRequestHandler, RequestTypeGetRequestHandler requestTypeGetRequestHandler, RequestTypeDeleteRequestHandler requestTypeDeleteRequestHandler, RequestTypeUpdateRequestHandler requestTypeUpdateRequestHandler, RequestTypeMoveRequestHandler requestTypeMoveRequestHandler, RequestTypeGroupGetRequestHandler requestTypeGroupGetRequestHandler, RestResponseHelper restResponseHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.requestTypeGroupService = requestTypeGroupService;
        this.internalPortalService = internalPortalService;
        this.userFactory = userFactory;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.requestTypeCreateRequestHandler = requestTypeCreateRequestHandler;
        this.requestTypeGetRequestHandler = requestTypeGetRequestHandler;
        this.requestTypeDeleteRequestHandler = requestTypeDeleteRequestHandler;
        this.requestTypeUpdateRequestHandler = requestTypeUpdateRequestHandler;
        this.requestTypeMoveRequestHandler = requestTypeMoveRequestHandler;
        this.requestTypeGroupGetRequestHandler = requestTypeGroupGetRequestHandler;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="/{groupId}/request-types")
    public Response getRequestTypes(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId) {
        return this.requestTypeGetRequestHandler.getAllRequestTypesInGroup(projectId, groupId);
    }

    @GET
    @Path(value="/{groupId}/other-request-types")
    public Response getOtherRequestTypes(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId) {
        return this.requestTypeGetRequestHandler.getAllRequestTypesNotInGroup(projectId, groupId);
    }

    @GET
    @Path(value="/{groupId}/request-types/{id}")
    public Response getRequestType(@PathParam(value="projectId") Long projectId, @PathParam(value="groupId") int groupId, @PathParam(value="id") Integer requestTypeId) {
        return this.requestTypeGetRequestHandler.getRequestType(projectId, requestTypeId);
    }

    @GET
    @Path(value="/{groupId}/delete-confirm")
    public Response getGroupDeleteConfirmation(@PathParam(value="projectId") Long projectId, @PathParam(value="groupId") int groupId) {
        return this.requestTypeGetRequestHandler.getGroupDeleteConfirmation(projectId, groupId);
    }

    @DELETE
    @Path(value="/{groupId}/request-types/{id}")
    public Response deleteRequestType(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId, @PathParam(value="id") Integer requestTypeId) {
        return this.requestTypeDeleteRequestHandler.deleteRequestType(projectId, requestTypeId);
    }

    @POST
    @Path(value="/{groupId}/request-types")
    public Response createRequestType(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId, RequestTypeCreateRequest toCreate) {
        return this.requestTypeCreateRequestHandler.createRequestTypeInGroup(projectId, toCreate, groupId);
    }

    @PUT
    @Path(value="/{groupId}/request-types/{id}")
    public Response updateRequestType(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId, @PathParam(value="id") Integer requestTypeId, RequestTypeUpdateRequest toUpdate) {
        return this.requestTypeUpdateRequestHandler.updateRequestType(projectId, requestTypeId, toUpdate);
    }

    @PUT
    @Path(value="/help-text/{id}")
    public Response updateRequestTypeHelpText(@PathParam(value="projectId") long projectId, @PathParam(value="id") Integer requestTypeId, RequestTypeHelpTextUpdateRequest requestTypeHelpTextUpdateRequest) {
        String helpTextValue = "";
        if (requestTypeHelpTextUpdateRequest.getHelpText() != null) {
            helpTextValue = requestTypeHelpTextUpdateRequest.getHelpText();
        }
        return this.requestTypeUpdateRequestHandler.updateRequestTypeHelpText(projectId, requestTypeId, helpTextValue);
    }

    @GET
    @Path(value="/")
    public Response getGroupsForProject(@PathParam(value="projectId") long projectId) {
        return this.requestTypeGroupGetRequestHandler.getGroupsForProject(projectId);
    }

    @POST
    @Path(value="/")
    public Response createRequestTypeGroup(@PathParam(value="projectId") long projectId, CreateRequestTypeGroupRequestDTO group) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeGroupService.createGroup(checkedUser, new PartialRequestTypeGroup(group.getName()), project, portal)).then((checkedUser, project, portal, createdGroup) -> io.atlassian.fugue.Either.right((Object)new CreateRequestTypeGroupResponseDTO((RequestTypeGroup)createdGroup))).yield((checkedUser, project, portal, createdGroup, result) -> result).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), groupResponse -> Response.ok((Object)groupResponse).build());
    }

    @POST
    @Path(value="/{groupId}/request-types/{id}/move")
    public Response reorderRequestTypes(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId, @PathParam(value="id") int requestTypeId, RESTfulTableReorderRequest reorderRequest) {
        return this.requestTypeMoveRequestHandler.reorderRequestTypes(projectId, groupId, requestTypeId, reorderRequest);
    }

    @GET
    @Path(value="/{groupId}")
    public Response getRequestTypeGroupById(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeGroupService.getGroup(checkedUser, project, portal, groupId)).yield((checkedUser, project, portal, group) -> new RequestTypeGroupDTO(group.getId(), group.getName())).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), groupResponse -> Response.ok((Object)groupResponse).build());
    }

    @PUT
    @Path(value="/{groupId}")
    public Response updateRequestTypeGroupName(@PathParam(value="projectId") long projectId, @PathParam(value="groupId") int groupId, UpdateRequestTypeGroupRequest request) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeGroupService.updateGroupName(checkedUser, project, portal, groupId, request.getName())).yield((checkedUser, project, portal, updatedGroup) -> new RequestTypeGroupDTO(updatedGroup.getId(), updatedGroup.getName())).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), groupResponse -> Response.ok((Object)groupResponse).build());
    }

    @PUT
    @Path(value="/")
    public Response bulkUpdateGroups(@PathParam(value="projectId") long projectId, BulkUpdateRequestTypeGroupRequest request) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeGroupService.softDeleteGroups(checkedUser, project, portal, request.deleted)).then((checkedUser, project, portal, deleted) -> this.requestTypeGroupService.updateGroupOrder(checkedUser, project, portal, request.order)).yield((checkedUser, project, portal, deleted, modified) -> RequestTypeGroupMappingHelper.getBulkUpdateResponse(deleted, modified)).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), groupResponse -> Response.ok((Object)groupResponse).build());
    }

    @POST
    @Path(value="/undo")
    public Response undoOperations(@PathParam(value="projectId") long projectId, UndoOperationsRequest request) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(projectId))).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeGroupService.undoGroupDeletes(checkedUser, project, portal, request.timestamp)).yield((checkedUser, project, portal, affectedGroups) -> RequestTypeGroupMappingHelper.getUndoResponse(affectedGroups)).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), restoreResponse -> Response.ok((Object)restoreResponse).build());
    }
}

