/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group;

import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.internal.api.requesttype.group.SoftDeleteRequestTypeGroupResponse;
import com.atlassian.servicedesk.internal.rest.requesttype.group.BulkUpdateRequestTypeGroupResponse;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeGroupDTO;
import com.atlassian.servicedesk.internal.rest.requesttype.group.UndoOperationsResponse;
import java.util.List;
import java.util.stream.Collectors;

public class RequestTypeGroupMappingHelper {
    public static UndoOperationsResponse getUndoResponse(List<RequestTypeGroup> affectedGroups) {
        return new UndoOperationsResponse(RequestTypeGroupMappingHelper.mapRequestTypeGroupListToDtoArray(affectedGroups));
    }

    public static BulkUpdateRequestTypeGroupResponse getBulkUpdateResponse(SoftDeleteRequestTypeGroupResponse deleted, List<RequestTypeGroup> reordered) {
        RequestTypeGroupDTO[] reorderedArr = RequestTypeGroupMappingHelper.mapRequestTypeGroupListToDtoArray(reordered);
        RequestTypeGroupDTO[] deletedArr = RequestTypeGroupMappingHelper.mapRequestTypeGroupListToDtoArray(deleted.getDeletedGroups());
        return new BulkUpdateRequestTypeGroupResponse(reorderedArr, deletedArr, deleted.getDeletedTime());
    }

    public static RequestTypeGroupDTO[] mapRequestTypeGroupListToDtoArray(List<RequestTypeGroup> groups) {
        return groups.stream().map(g -> RequestTypeGroupMappingHelper.mapRequestTypeGroupToDTO(g)).collect(Collectors.toList()).toArray(new RequestTypeGroupDTO[0]);
    }

    public static RequestTypeGroupDTO mapRequestTypeGroupToDTO(RequestTypeGroup group) {
        return new RequestTypeGroupDTO(group.getId(), group.getName());
    }
}

