/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requests;

import com.atlassian.servicedesk.internal.api.webfragments.PortalPage;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ResponseProviderModelName;
import com.atlassian.servicedesk.internal.feature.feedback.AnFeedbackError;
import com.atlassian.servicedesk.internal.rest.requests.FeedbackOptions;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequestOptions;
import com.atlassian.servicedesk.internal.rest.requests.Options;
import com.atlassian.servicedesk.internal.rest.requests.PortalWebFragmentsOptions;
import com.atlassian.servicedesk.internal.rest.requests.RequestListFilterOptions;
import com.atlassian.servicedesk.internal.rest.requests.UnsubscribedConfirmationOptions;
import com.atlassian.servicedesk.internal.rest.requests.VisitPortalOptions;
import com.atlassian.servicedesk.internal.rest.requests.kb.KbPageOptions;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class ModelsRequest {
    List<String> models = new ArrayList<String>();
    ModelsRequestOptions options = new ModelsRequestOptions();

    public ModelsRequest login() {
        this.models.add(ResponseProviderModelName.LOGIN_MODEL_NAME);
        return this;
    }

    public ModelsRequest timezoneRegions() {
        this.models.add(ResponseProviderModelName.TIME_ZONE_REGIONS_MODEL_NAME);
        return this;
    }

    public ModelsRequest timezones() {
        this.models.add(ResponseProviderModelName.TIME_ZONES_MODEL_NAME);
        return this;
    }

    public ModelsRequest profileWebFragments() {
        this.models.add(ResponseProviderModelName.PROFILE_WEB_FRAGMENTS_MODEL_NAME);
        return this;
    }

    public ModelsRequest portalWebFragments(PortalPage portalPage) {
        this.models.add(ResponseProviderModelName.PORTAL_WEB_FRAGMENTS_MODEL_NAME);
        this.options.portalWebFragments(new PortalWebFragmentsOptions().portalPage(portalPage));
        return this;
    }

    public ModelsRequest forgotPassword() {
        this.models.add(ResponseProviderModelName.FORGOT_PASSWORD_MODEL_NAME);
        return this;
    }

    public ModelsRequest portals() {
        this.models.add(ResponseProviderModelName.PORTALS_MODEL_NAME);
        return this;
    }

    public ModelsRequest sharedPortal() {
        this.models.add(ResponseProviderModelName.SHARED_PORTAL_MODEL_NAME);
        return this;
    }

    public ModelsRequest visitPortal(long portalId, String username, String token) {
        this.models.add(ResponseProviderModelName.VISIT_PORTAL_MODEL_NAME);
        this.options.visitPortal(new VisitPortalOptions().portalId(portalId).username(username).token(token));
        return this;
    }

    public ModelsRequest signUp() {
        this.models.add(ResponseProviderModelName.SIGN_UP_MODEL_NAME);
        return this;
    }

    public ModelsRequest portal(Long portalId) {
        return this.portal(portalId, null);
    }

    public ModelsRequest portal(Long portalId, List<String> expand) {
        if (expand == null) {
            expand = new ArrayList<String>();
        }
        this.models.add(ResponseProviderModelName.PORTAL_MODEL_NAME);
        this.options.portalId(portalId);
        this.options.portal(new Options().id(portalId).expand(expand));
        return this;
    }

    public ModelsRequest reqCreate(long id) {
        this.models.add(ResponseProviderModelName.REQ_CREATE_MODEL_NAME);
        this.options.reqCreate(new Options().id(id));
        return this;
    }

    public ModelsRequest reqDetails(String key) {
        this.models.add(ResponseProviderModelName.REQ_DETAILS_MODEL_NAME);
        this.options.reqDetails(new Options().key(key));
        return this;
    }

    public ModelsRequest allReqFilter(String reporter, String status, String filter2, Integer selectedPage, Integer portalId, Integer requestTypeId) {
        return this.allReqFilter(reporter, status, filter2, selectedPage, portalId, requestTypeId, null);
    }

    public ModelsRequest allReqFilter(String reporter, String status, String filter2, Integer selectedPage, Integer portalId, Integer requestTypeId, List<String> expand) {
        if (selectedPage == null) {
            selectedPage = 1;
        }
        if (expand == null) {
            expand = new ArrayList<String>();
        }
        this.models.add(ResponseProviderModelName.ALL_REQ_FILTER_MODEL_NAME);
        this.options.allReqFilter(new RequestListFilterOptions().reporter(reporter).status(status).filter(filter2).selectedPage(selectedPage).portalId(portalId).requestTypeId(requestTypeId).expand(expand));
        return this;
    }

    public ModelsRequest branding(long portalId) {
        this.options.portalId(portalId);
        this.options.branding(new Options().id(portalId));
        this.models.add(ResponseProviderModelName.BRANDING_MODEL_NAME);
        return this;
    }

    public ModelsRequest helpCenterBranding() {
        this.models.add(ResponseProviderModelName.HELP_CENTER_BRANDING_MODEL_NAME);
        return this;
    }

    public ModelsRequest user() {
        this.models.add(ResponseProviderModelName.USER_MODEL_NAME);
        return this;
    }

    public ModelsRequest feedback(Option<Integer> rating, String token, Option<AnFeedbackError> error) {
        this.models.add(ResponseProviderModelName.FEEDBACK_CONFIRM_MODEL_NAME);
        this.options.feedback(new FeedbackOptions().rating(rating).token(token).error(error));
        return this;
    }

    public ModelsRequest passwordPolicy() {
        this.models.add(ResponseProviderModelName.PASSWORD_POLICY_MODEL_NAME);
        return this;
    }

    public ModelsRequest kbPage(long pageId, String applicationId) {
        this.models.add(ResponseProviderModelName.KB_PAGE_MODEL_NAME);
        this.options.kbPage(new KbPageOptions().setId(pageId).setApplicationId(applicationId));
        return this;
    }

    public ModelsRequest recentRequestTypes() {
        this.models.add(ResponseProviderModelName.RECENT_REQUEST_TYPE_MODEL_NAME);
        return this;
    }

    public ModelsRequest popularServiceDesk() {
        this.models.add(ResponseProviderModelName.POPULAR_PORTAL_MODEL_NAME);
        return this;
    }

    public ModelsRequest unsubscribedConfirmation(UnsubscribedConfirmationOptions unsubscribedOptions) {
        this.models.add(ResponseProviderModelName.UNSUBSCRIBED_CONFIRMATION_MODEL_NAME);
        this.options.unsubscribedConfirmation(unsubscribedOptions);
        return this;
    }

    public ModelsRequest organisations() {
        this.models.add(ResponseProviderModelName.ORGANISATIONS_MODEL_NAME);
        return this;
    }

    @JsonProperty
    public ModelsRequest models(List<String> models) {
        this.models = models;
        return this;
    }

    @JsonProperty
    public ModelsRequest options(ModelsRequestOptions options) {
        this.options = options;
        return this;
    }

    public List<String> getModels() {
        return this.models;
    }

    public ModelsRequestOptions getOptions() {
        return this.options;
    }
}

