/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requestnotification;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.analytics.ServiceDeskInternalAnalyticsSourceService;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.errors.SubscriptionErrors;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.email.RequestEmailSubscriptionService;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.requests.UnsubscribedConfirmationOptions;
import com.atlassian.servicedesk.internal.web.CustomerPageRenderer;
import io.atlassian.fugue.Either;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="customer/subscription")
public class UnsubscribedConfirmationPage {
    private final FeatureManager featureManager;
    private final RequestEmailSubscriptionService emailSubscriptionService;
    private final IssueManager issueManager;
    private final PortalInternalManager portalInternalManager;
    private final CommonErrors commonErrors;
    private final CustomerPageRenderer customerPageRenderer;
    private final ServiceDeskInternalAnalyticsSourceService serviceDeskInternalAnalyticsSourceService;
    private final SubscriptionErrors subscriptionErrors;

    public UnsubscribedConfirmationPage(FeatureManager featureManager, RequestEmailSubscriptionService emailSubscriptionService, IssueManager issueManager, PortalInternalManager portalInternalManager, CommonErrors commonErrors, CustomerPageRenderer customerPageRenderer, ServiceDeskInternalAnalyticsSourceService serviceDeskInternalAnalyticsSourceService, SubscriptionErrors subscriptionErrors) {
        this.featureManager = featureManager;
        this.emailSubscriptionService = emailSubscriptionService;
        this.issueManager = issueManager;
        this.portalInternalManager = portalInternalManager;
        this.commonErrors = commonErrors;
        this.customerPageRenderer = customerPageRenderer;
        this.serviceDeskInternalAnalyticsSourceService = serviceDeskInternalAnalyticsSourceService;
        this.subscriptionErrors = subscriptionErrors;
    }

    @GET
    @AnonymousAllowed
    @Path(value="unsubscribe/portal/{portalId}/{requestKey}")
    @Produces(value={"text/html"})
    public Response unsubscribeUpdatePage(@PathParam(value="portalId") long portalId, @PathParam(value="requestKey") String requestKey, @QueryParam(value="jwt") String jwtToken) {
        if (StringUtils.isEmpty((String)jwtToken)) {
            return Response.status((int)HttpStatusCode.FORBIDDEN).build();
        }
        UnsubscribedConfirmationOptions confirmPageOptions = (UnsubscribedConfirmationOptions)Steps.begin(this.getIssue(requestKey)).then(issue -> this.portalInternalManager.getPortalById(portalId)).then((issue, portal) -> this.getJwtPayload()).then((issue, portal, jwtPayload) -> this.emailSubscriptionService.unsubscribeFromEmail((Issue)issue, jwtToken, (String)jwtPayload)).yield((issue, portal, jwtPayload, unit) -> this.buildUnsubscribedConfirmationSuccessOption((Issue)issue, (PortalInternal)portal)).fold(this::buildUnsubscribedConfirmationErrorOption, successOptions -> successOptions);
        return this.renderUnsubscribedConfirmationPage(confirmPageOptions);
    }

    private Either<AnError, Issue> getIssue(String issueKey) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null) {
            return Either.left((Object)this.commonErrors.REQUEST_NOT_FOUND());
        }
        return Either.right((Object)issue);
    }

    private Either<AnError, String> getJwtPayload() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request == null) {
            return Either.left((Object)this.subscriptionErrors.INVALID_UNSUBSCRIPTION_LINK());
        }
        String jwtPayload = (String)request.getAttribute("jwt.payload");
        if (StringUtils.isBlank((String)jwtPayload)) {
            return Either.left((Object)this.subscriptionErrors.INVALID_UNSUBSCRIPTION_LINK());
        }
        return Either.right((Object)jwtPayload);
    }

    private UnsubscribedConfirmationOptions buildUnsubscribedConfirmationErrorOption(AnError error) {
        return new UnsubscribedConfirmationOptions().error(error);
    }

    private UnsubscribedConfirmationOptions buildUnsubscribedConfirmationSuccessOption(Issue issue, PortalInternal portal) {
        this.serviceDeskInternalAnalyticsSourceService.fireRequestUnsubscribedRaisedViaEmailEvent(portal.getProjectId());
        return new UnsubscribedConfirmationOptions().issueKey(issue.getKey()).portalId(portal.getId());
    }

    private Response renderUnsubscribedConfirmationPage(UnsubscribedConfirmationOptions unsubscribedConfirmationOptions) {
        return this.customerPageRenderer.createPage(new ModelsRequest().helpCenterBranding().unsubscribedConfirmation(unsubscribedConfirmationOptions), false, false);
    }
}

