/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requestnotification;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorCollectionHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="customer/notification/subscription/{issueId}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationSubscriptionResource {
    private final NotificationSubscriptionService notificationService;
    private final UserFactory userFactory;
    private final IssueService issueService;
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final RestResponseHelper restResponseHelper;

    public NotificationSubscriptionResource(NotificationSubscriptionService notificationService, UserFactory userFactory, IssueService issueService, FeatureManager featureManager, CommonErrors commonErrors, RestResponseHelper restResponseHelper) {
        this.notificationService = notificationService;
        this.userFactory = userFactory;
        this.issueService = issueService;
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
        this.restResponseHelper = restResponseHelper;
    }

    @PUT
    public Response subscribe(@PathParam(value="issueId") long issueId) {
        return this.updateSubscription(issueId, true);
    }

    @DELETE
    public Response unsubscribe(@PathParam(value="issueId") long issueId) {
        return this.updateSubscription(issueId, false);
    }

    private Response updateSubscription(long issueId, boolean doSubscribe) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(currentUser -> this.getIssue(issueId, (CheckedUser)currentUser)).then((currentUser, issue) -> {
            if (doSubscribe) {
                return this.notificationService.subscribe((CheckedUser)currentUser, (Issue)issue);
            }
            return this.notificationService.unsubscribe((CheckedUser)currentUser, (Issue)issue);
        }).yield((currentUser, issue, updated) -> updated);
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }

    @GET
    public Response isSubscribed(@PathParam(value="issueId") long issueId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(currentUser -> this.getIssue(issueId, (CheckedUser)currentUser)).then(this.notificationService::isSubscribed).yield((currentUser, issue, isSubscribed) -> isSubscribed);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, Issue> getIssue(long issueId, CheckedUser currentUser) {
        IssueService.IssueResult result = this.issueService.getIssue(currentUser.forJIRA(), Long.valueOf(issueId));
        if (!result.isValid()) {
            return StepsConverters.newerEither((Either)ErrorCollectionHelper.error((ErrorCollection)result.getErrorCollection()));
        }
        return io.atlassian.fugue.Either.right((Object)result.getIssue());
    }
}

