/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.outsiders;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.shareparticipants.ShareParticipantsService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.share.request.ShareParticipantsRequest;
import com.atlassian.servicedesk.internal.rest.outsiders.OutsiderShareParticipantsRequest;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/participants")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ProjectShareParticipantResource {
    private final FeatureManager featureManager;
    private final RestResponseHelper restResponseHelper;
    private final CommonErrors commonErrors;
    private final IssueHelper issueHelper;
    private final UserFactory userFactory;
    private final ShareParticipantsService shareParticipantsService;

    public ProjectShareParticipantResource(FeatureManager featureManager, RestResponseHelper restResponseHelper, CommonErrors commonErrors, IssueHelper issueHelper, UserFactory userFactory, ShareParticipantsService shareParticipantsService) {
        this.featureManager = featureManager;
        this.restResponseHelper = restResponseHelper;
        this.commonErrors = commonErrors;
        this.issueHelper = issueHelper;
        this.userFactory = userFactory;
        this.shareParticipantsService = shareParticipantsService;
    }

    @PUT
    @Path(value="{issueKey}/outsider/share")
    public Response addOutsiderToParticipants(@PathParam(value="issueKey") String issueKey, @Nonnull OutsiderShareParticipantsRequest outsiderShareParticipantsRequest) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        Objects.requireNonNull(issueKey, "issueKey");
        Objects.requireNonNull(outsiderShareParticipantsRequest, "outsiderParticipantsRequest");
        ShareParticipantsRequest shareParticipantsRequest = new ShareParticipantsRequest();
        Option.option((Object)outsiderShareParticipantsRequest.getUsername()).forEach(username -> shareParticipantsRequest.setUsernames((List<String>)ImmutableList.of((Object)username)));
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.issueHelper.getIssueByKey((CheckedUser)user, issueKey)).then((user, issue) -> this.shareParticipantsService.shareParticipants((CheckedUser)user, (Issue)issue, shareParticipantsRequest)).yield((user, issue, shareResult) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }
}

