/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.organization;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsParams;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsResult;
import com.atlassian.servicedesk.internal.feature.organization.project.CustomerOrganizationProjectService;
import com.atlassian.servicedesk.internal.rest.organization.request.InviteCustomerOrganisationRequest;
import com.atlassian.servicedesk.internal.rest.organization.response.InviteCustomerOrganisationInvalidIdResponse;
import java.util.HashSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/servicedesk/{projectId}/organisation")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomerOrganisationProjectResource {
    private final CustomerOrganizationProjectService customerOrganizationProjectService;
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final RestResponseHelper restResponseHelper;
    private final CustomerOrganizationService customerOrganizationService;

    @Autowired
    public CustomerOrganisationProjectResource(CustomerOrganizationProjectService customerOrganizationProjectService, UserFactory userFactory, ServiceDeskProjectService serviceDeskProjectService, RestResponseHelper restResponseHelper, CustomerOrganizationService customerOrganizationService) {
        this.customerOrganizationProjectService = customerOrganizationProjectService;
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.restResponseHelper = restResponseHelper;
        this.customerOrganizationService = customerOrganizationService;
    }

    @PUT
    @Path(value="/invite")
    public Response inviteOrganisation(@PathParam(value="projectId") long projectId, InviteCustomerOrganisationRequest request) {
        return this.inviteOrganisationImpl(projectId, request);
    }

    @POST
    @Path(value="/{organisationId}/dissasociate")
    public Response dissasociateProject(@PathParam(value="projectId") long projectId, @PathParam(value="organisationId") int organisationId) {
        return this.dissasociateProjectImpl(projectId, organisationId);
    }

    private Response inviteOrganisationImpl(long projectId, InviteCustomerOrganisationRequest request) {
        io.atlassian.fugue.Either inviteResult = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, projectId)).then((user, project) -> io.atlassian.fugue.Either.right((Object)new InviteCustomerOrganizationsParams(request.getNewOrganisationNames(), request.getExistingOrganisationIds(), (Project)project))).then((user, project, inviteParams) -> this.customerOrganizationProjectService.addOrganizations((CheckedUser)user, (InviteCustomerOrganizationsParams)inviteParams)).yield((user, project, inviteParams, result) -> result);
        if (inviteResult.isLeft()) {
            return this.restResponseHelper.anErrorToResponse((AnError)inviteResult.left().get());
        }
        if (((InviteCustomerOrganizationsResult)inviteResult.right().get()).hasInvalidIds()) {
            return this.restResponseHelper.badRequest((Object)new InviteCustomerOrganisationInvalidIdResponse(new HashSet<Integer>(((InviteCustomerOrganizationsResult)inviteResult.right().get()).getInvalidIds())));
        }
        return this.restResponseHelper.noContent();
    }

    private Response dissasociateProjectImpl(long projectId, int organisationId) {
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, projectId)).then((user, project) -> this.customerOrganizationService.getOrganization((CheckedUser)user, organisationId)).then((user, project, organisation) -> this.customerOrganizationProjectService.disassociateOrganization((CheckedUser)user, (Project)project, (CustomerOrganization)organisation)).yield((user, project, organisation, result) -> result).fold(error -> this.restResponseHelper.anErrorToResponse(error), unit -> this.restResponseHelper.noContent());
    }
}

