/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.organization;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.responses.CustomerOrganisationResponse;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="customer/organisations")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomerOrganisationPortalResource {
    private final UserFactory userFactory;
    private final ServiceDeskProjectService projectService;
    private final CustomerOrganizationMemberService organisationMemberService;
    private final RestResponseHelper restResponseHelper;

    public CustomerOrganisationPortalResource(UserFactory userFactory, ServiceDeskProjectService projectService, CustomerOrganizationMemberService organisationMemberService, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.projectService = projectService;
        this.organisationMemberService = organisationMemberService;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="project/{projectId}/member/{username}")
    public Response getCustomerOrganisationsInProject(@PathParam(value="projectId") long projectId, @PathParam(value="username") String customerUserName) {
        return this.getCustomerOrganisationsInProjectImpl(projectId, customerUserName);
    }

    private Response getCustomerOrganisationsInProjectImpl(long projectId, String customerUserName) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.projectService.getProjectById((CheckedUser)user, projectId)).then((user, project) -> StepsConverters.newerEither((Either)this.userFactory.wrapUsername(customerUserName))).then((user, project, customer) -> this.organisationMemberService.getUserOrganizationsInProjectAsAgent(user, customer, project)).yield((user, project, customer, organisations) -> this.mapToOrganisationsResponse((Collection<CustomerOrganization>)organisations));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private Collection<CustomerOrganisationResponse> mapToOrganisationsResponse(Collection<CustomerOrganization> organisations) {
        return organisations.stream().map(org -> new CustomerOrganisationResponse(org.getId(), org.getName())).collect(Collectors.toList());
    }
}

