/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.organization;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/organisation/{organisationId}/membership")
public class CustomerOrganisationMemberResource {
    private final CustomerOrganizationMemberService organisationMemberService;
    private final UserFactory userFactory;
    private final CustomerOrganizationService organisationService;
    private final RestResponseHelper restResponseHelper;

    public CustomerOrganisationMemberResource(CustomerOrganizationMemberService organisationMemberService, UserFactory userFactory, CustomerOrganizationService organisationService, RestResponseHelper restResponseHelper) {
        this.organisationMemberService = organisationMemberService;
        this.userFactory = userFactory;
        this.organisationService = organisationService;
        this.restResponseHelper = restResponseHelper;
    }

    @DELETE
    @Path(value="/{userKey}")
    public Response removeFromOrganisation(@PathParam(value="organisationId") int organisationId, @PathParam(value="userKey") String userKey) {
        return this.removeFromOrganisationImpl(organisationId, userKey);
    }

    private Response removeFromOrganisationImpl(int organisationId, String userKey) {
        return this.restResponseHelper.anErrorEitherToNoContentResponse(Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.organisationService.getOrganization((CheckedUser)checkedUser, organisationId)).then((checkedUser, organisation) -> StepsConverters.newerEither((Either)this.userFactory.wrapUserKey(userKey))).then((checkedUser, organisation, userToRemove) -> this.organisationMemberService.removeUsersFromOrganization(checkedUser, organisation, (Set)Sets.newHashSet((Object[])new CheckedUser[]{userToRemove}))).yield((checkedUser, organisation, userToRemove, result) -> result));
    }
}

