/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.inviteteam;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.user.ServiceDeskUserManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.InviteService;
import com.atlassian.servicedesk.internal.rest.requests.ResetPasswordRequest;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/agent")
public class ServiceDeskInviteAgentResource {
    private final InviteService inviteService;
    private final ServiceDeskUserManager serviceDeskUserManager;
    private final RestResponseHelper restResponseHelper;

    public ServiceDeskInviteAgentResource(InviteService inviteService, ServiceDeskUserManager serviceDeskUserManager, RestResponseHelper restResponseHelper) {
        this.inviteService = inviteService;
        this.serviceDeskUserManager = serviceDeskUserManager;
        this.restResponseHelper = restResponseHelper;
    }

    @POST
    @AnonymousAllowed
    @Path(value="/setpassword")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doSetPassword(ResetPasswordRequest request) {
        return this.restResponseHelper.anErrorEitherToNoContentResponse(this.setInviteeDetails(request));
    }

    private Either<AnError, Unit> setInviteeDetails(ResetPasswordRequest request) {
        return Steps.begin(this.serviceDeskUserManager.validateFullname(request.getFullname())).then(fullName -> this.inviteService.setPasswordForInvitee(request.getUsername(), request.getPassword(), request.getToken(), request.getProjectKey())).then((fullName, agent) -> this.serviceDeskUserManager.updateUserFullName((CheckedUser)agent, (String)fullName)).yield((fullName, agent, success) -> Unit.Unit());
    }
}

