/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.inviteteam;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskApplicationLicenseService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectServiceScala;
import com.atlassian.servicedesk.internal.feature.usermanagement.AgentManagementErrorDataProvider;
import com.atlassian.servicedesk.internal.feature.usermanagement.AgentService;
import com.atlassian.servicedesk.internal.feature.usermanagement.ServiceDeskTeamService;
import com.atlassian.servicedesk.internal.permission.restore.PermissionSchemeMisconfigurationService;
import com.atlassian.servicedesk.internal.rest.inviteteam.AgentAddedResponse;
import com.atlassian.servicedesk.internal.rest.inviteteam.InviteTeamRequest;
import com.atlassian.servicedesk.internal.rest.inviteteam.InviteTeamResponse;
import com.atlassian.servicedesk.internal.user.ServiceDeskUserManagerScala;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.web.pagedata.AgentEntityBuilder;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{projectKey}/inviteteam")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class InviteTeamResource {
    private final UserFactory userFactory;
    private final ServiceDeskProjectServiceScala serviceDeskProjectService;
    private final ServiceDeskTeamService serviceDeskTeamService;
    private final ServiceDeskUserManagerScala sdUserManager;
    private final ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService;
    private final AgentEntityBuilder agentEntityBuilder;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService;
    private final AgentManagementErrorDataProvider agentManagementErrorDataProvider;
    private final AgentService agentService;
    private final RestResponseHelper restResponseHelper;

    public InviteTeamResource(AgentEntityBuilder agentEntityBuilder, UserFactory userFactory, ServiceDeskProjectServiceScala serviceDeskProjectService, ServiceDeskTeamService serviceDeskTeamService, ServiceDeskUserManagerScala sdUserManager, ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService, ServiceDeskPermissions serviceDeskPermissions, PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService, AgentManagementErrorDataProvider agentManagementErrorDataProvider, AgentService agentService, RestResponseHelper restResponseHelper) {
        this.agentEntityBuilder = agentEntityBuilder;
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.serviceDeskTeamService = serviceDeskTeamService;
        this.sdUserManager = sdUserManager;
        this.serviceDeskApplicationLicenseService = serviceDeskApplicationLicenseService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.permissionSchemeMisconfigurationService = permissionSchemeMisconfigurationService;
        this.agentManagementErrorDataProvider = agentManagementErrorDataProvider;
        this.agentService = agentService;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response inviteTeamConfig(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).yield((user, project) -> new InviteTeamResponse(project.getId(), project.getName(), this.serviceDeskApplicationLicenseService.getAgentLicenseCapacityOrUnlimited(), this.getTotalAgentCount((CheckedUser)user), this.sdUserManager.getLicensedJiraUserCount(), this.agentEntityBuilder.showAgentLicenseCapacity(), this.serviceDeskApplicationLicenseService.isEvaluationLicense(), this.serviceDeskPermissions.canManageLicenses((SDUser)user), this.permissionSchemeMisconfigurationService.isTeamRoleCriticallyMisconfigured((Project)project), this.permissionSchemeMisconfigurationService.isAdminRoleCriticallyMisconfigured((Project)project), this.agentManagementErrorDataProvider.getData(), false));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    public Response inviteTeam(@PathParam(value="projectKey") String projectKey, InviteTeamRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.doInviteTeam((CheckedUser)user, (Project)project, request)).yield((user, project, agentAddedResponse) -> agentAddedResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, AgentAddedResponse> doInviteTeam(CheckedUser user, Project project, InviteTeamRequest request) {
        return Steps.begin(this.addAgents(user, project, request.getAgentsToAdd())).then(jsd1 -> this.promoteAgents(user, project, request.getAgentsToPromote())).then((jsd1, jsd2) -> this.allocateAgents(user, project, request.getAgentsToAllocate())).yield((jsd1, jsd2, jsd3) -> new AgentAddedResponse(this.getTotalAgentCount(user), this.sdUserManager.getLicensedJiraUserCount()));
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> addAgents(CheckedUser user, Project project, List<String> emails) {
        if (emails == null || emails.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
        }
        for (String email : emails) {
            io.atlassian.fugue.Either result = Steps.begin(this.agentService.addAgent(user, email, email, email)).then(agent -> this.serviceDeskTeamService.allocateUser(user, (CheckedUser)agent, project)).yield((agent, agent2) -> JSDSuccess.success());
            if (!result.isLeft()) continue;
            return result;
        }
        return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> promoteAgents(CheckedUser user, Project project, List<String> userKeys) {
        if (userKeys == null || userKeys.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
        }
        for (String userKey : userKeys) {
            io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrapUserKey(userKey))).then(userToPromote -> this.agentService.promoteUserToAgent(user, (CheckedUser)userToPromote)).then((userToPromote, agent) -> this.serviceDeskTeamService.allocateUser(user, (CheckedUser)agent, project)).yield((userToPromote, agent, agent2) -> JSDSuccess.success());
            if (!result.isLeft()) continue;
            return result;
        }
        return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> allocateAgents(CheckedUser user, Project project, List<String> userKeys) {
        if (userKeys == null || userKeys.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
        }
        for (String userKey : userKeys) {
            io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrapUserKey(userKey))).then(agent -> this.serviceDeskTeamService.allocateUser(user, (CheckedUser)agent, project)).yield((agent, agent2) -> JSDSuccess.success());
            if (!result.isLeft()) continue;
            return result;
        }
        return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
    }

    private Integer getTotalAgentCount(CheckedUser user) {
        return (Integer)this.agentService.getTotalAgentCount(user).getOrElse((Object)-1);
    }
}

