/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.info;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.servicedesk.bootstrap.version.BuildProperties;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.rest.info.ServiceDeskInfoResponse;
import io.atlassian.fugue.Option;
import java.util.Locale;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousAllowed
@Path(value="/servicedesk/info")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServiceDeskInfoResource {
    private final BuildProperties buildProperties;
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;

    @Autowired
    public ServiceDeskInfoResource(BuildProperties buildProperties, ServiceDeskOperationalStatus serviceDeskOperationalStatus) {
        this.buildProperties = buildProperties;
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
    }

    @GET
    public Response getSDInfo() {
        String buildDate = DateTimeFormat.mediumDateTime().withLocale(Locale.ENGLISH).withZone(DateTimeZone.forID((String)"Australia/Sydney")).print((ReadableInstant)this.buildProperties.getBuildDate());
        ServiceDeskInfoResponse infoResponse = new ServiceDeskInfoResponse();
        infoResponse.setVersion(this.buildProperties.getVersion());
        infoResponse.setLicenseValid(this.serviceDeskOperationalStatus.isOperational());
        infoResponse.setBuildDate(buildDate);
        infoResponse.setChangeSet((String)Option.option((Object)this.buildProperties.getChangeSet()).getOrElse((Object)""));
        return Response.ok((Object)infoResponse).build();
    }
}

