/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.feedback;

import com.atlassian.jira.issue.Issue;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.feedbackevents.FeedbackAnalyticEvent;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackParameters;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackToken;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackInternalService;
import com.atlassian.servicedesk.internal.feature.feedback.AnFeedbackError;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackErrors;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.requests.SubmitFeedbackRequest;
import com.atlassian.servicedesk.internal.utils.Convert;
import com.atlassian.servicedesk.internal.web.CustomerPageRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

@Path(value="customer/feedback")
public class ServiceRequestFeedbackResource {
    private final CustomerPageRenderer customerPageRenderer;
    private final ServiceDeskIssueManager issueManager;
    private final RequestFeedbackInternalService requestFeedbackInternalService;
    private final AnalyticsService analyticService;
    private final FeedbackErrors feedbackErrors;

    public ServiceRequestFeedbackResource(CustomerPageRenderer customerPageRenderer, RequestFeedbackInternalService requestFeedbackInternalService, ServiceDeskIssueManager issueManager, AnalyticsService analyticService, FeedbackErrors feedbackErrors) {
        this.customerPageRenderer = customerPageRenderer;
        this.requestFeedbackInternalService = requestFeedbackInternalService;
        this.issueManager = issueManager;
        this.analyticService = analyticService;
        this.feedbackErrors = feedbackErrors;
    }

    @GET
    @AnonymousAllowed
    @Path(value="portal/{portalId}/{requestKey}")
    public Response feedbackConfirmPage(@PathParam(value="portalId") long portalId, @PathParam(value="requestKey") String requestKey, @QueryParam(value="rating") String ratingString, @QueryParam(value="token") String token) {
        Option ratingOpt = Option.option((Object)ratingString).map(NumberUtils::toInt);
        Either<AnError, Issue> issueEither = this.issueManager.getIssueByKey(requestKey);
        if (issueEither.isLeft()) {
            return this.renderConfirmPage((Option<Integer>)ratingOpt, token, (Option<AnError>)Option.some((Object)this.feedbackErrors.ISSUE_NOT_FOUND()));
        }
        Option storeFeedbackResult = ratingOpt.flatMap(rating -> {
            FeedbackToken feedbackToken;
            FeedbackParameters feedbackParameters;
            Issue issue = (Issue)issueEither.right().get();
            Either storeFeedbackResultEither = this.requestFeedbackInternalService.storeFeedback(issue, feedbackParameters = FeedbackParameters.newBuilder().rating(rating).build(), feedbackToken = new FeedbackToken(token, issue.getId()));
            if (storeFeedbackResultEither.isRight()) {
                this.fireRatingAnalyticEvent((int)rating, issue.getProjectId());
            }
            return storeFeedbackResultEither.left().toOption();
        });
        return this.renderConfirmPage((Option<Integer>)ratingOpt, token, (Option<AnError>)storeFeedbackResult);
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="portal/{portalId}/{requestKey}")
    public Response feedbackSubmitted(@PathParam(value="portalId") long portalId, @PathParam(value="requestKey") String requestKey, SubmitFeedbackRequest request) {
        FeedbackToken feedbackToken;
        FeedbackParameters feedbackParameters;
        Either storeFeedbackResult;
        Either<AnError, Issue> issueEither = this.issueManager.getIssueByKey(requestKey);
        if (issueEither.isLeft()) {
            return Response.status((int)this.feedbackErrors.ISSUE_NOT_FOUND().getHttpStatusCode()).build();
        }
        Issue issue = (Issue)issueEither.right().get();
        int rating = request.getRating();
        Option commentOpt = Option.none();
        if (request.getComment().isDefined() && StringUtils.isNotBlank((String)((String)request.getComment().get()))) {
            commentOpt = Option.some((Object)StringUtils.trim((String)((String)request.getComment().get())));
        }
        if ((storeFeedbackResult = this.requestFeedbackInternalService.storeFeedback(issue, feedbackParameters = FeedbackParameters.newBuilder().comment(commentOpt).rating(Integer.valueOf(request.getRating())).build(), feedbackToken = new FeedbackToken(request.getToken(), issue.getId()))).isLeft()) {
            return Response.status((int)((AnError)storeFeedbackResult.left().get()).getHttpStatusCode()).build();
        }
        long projectId = issue.getProjectId();
        this.fireRatingAnalyticEvent(rating, projectId);
        if (commentOpt.isDefined()) {
            this.fireCommentAnalyticEvent(rating, projectId);
        }
        return Response.noContent().build();
    }

    private Response renderConfirmPage(Option<Integer> rating, String token, Option<AnError> error) {
        if (error.map(AnError::getHttpStatusCode).exists(code -> code == HttpStatusCode.NOT_FOUND)) {
            return Response.status((int)HttpStatusCode.NOT_FOUND).build();
        }
        ModelsRequest modelsRequest = new ModelsRequest();
        Option feedbackErrorOption = error.map(Convert::toFeedbackError);
        return this.customerPageRenderer.createPage(modelsRequest.helpCenterBranding().feedback(rating, token, (Option<AnFeedbackError>)feedbackErrorOption), false, false);
    }

    private void fireRatingAnalyticEvent(int rating, long projectId) {
        FeedbackAnalyticEvent event = new FeedbackAnalyticEvent("servicedesk.action.ticket.rated", Long.valueOf(projectId));
        this.analyticService.fireAnalyticsEvent((AnalyticsEvent)event);
        switch (rating) {
            case 1: {
                this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.rated.one.star", Long.valueOf(projectId)));
                break;
            }
            case 2: {
                this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.rated.two.star", Long.valueOf(projectId)));
                break;
            }
            case 3: {
                this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.rated.three.star", Long.valueOf(projectId)));
                break;
            }
            case 4: {
                this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.rated.four.star", Long.valueOf(projectId)));
                break;
            }
            case 5: {
                this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.rated.five.star", Long.valueOf(projectId)));
            }
        }
    }

    private void fireCommentAnalyticEvent(int rating, long projectId) {
        if (rating < 3) {
            this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.commented.negative", Long.valueOf(projectId)));
        } else if (rating == 3) {
            this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.commented.neutral", Long.valueOf(projectId)));
        } else {
            this.analyticService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.ticket.commented.positive", Long.valueOf(projectId)));
        }
    }
}

