/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.feedback;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReport;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportResult;
import com.atlassian.servicedesk.internal.rest.feedback.response.FeedbackReportPageResponse;
import com.atlassian.servicedesk.internal.rest.feedback.response.FeedbackReportResponse;
import com.atlassian.servicedesk.internal.rest.feedback.response.FeedbackReportResultResponse;
import com.atlassian.servicedesk.internal.rest.feedback.response.FeedbackSummaryResponse;
import com.atlassian.servicedesk.internal.web.ProjectUrlsProviderImpl;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FeedbackReportDataProvider {
    private static final String FEEDBACK_DATE_FORMAT = "dd/MMM/yyyy";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final DateTimeFormatter dateTimeFormatter;
    private final ProjectUrlsProviderImpl projectUrlsProvider;
    private final AvatarService avatarService;

    @Autowired
    public FeedbackReportDataProvider(JiraAuthenticationContext jiraAuthenticationContext, DateTimeFormatter dateTimeFormatter, ProjectUrlsProviderImpl projectUrlsProvider, AvatarService avatarService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.dateTimeFormatter = dateTimeFormatter;
        this.projectUrlsProvider = projectUrlsProvider;
        this.avatarService = avatarService;
    }

    public FeedbackReportResultResponse buildFeedbackReportResource(FeedbackReportResult reportResult) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        List<FeedbackReportResponse> reportResponseList = reportResult.getReportPageResponse().getFeedbackReports().stream().map(report -> {
            FeedbackReportResponse response = new FeedbackReportResponse((FeedbackReport)report);
            report.getFeedbackDate().forEach(date -> response.setFeedbackDate(this.formatFeedbackDate(loggedInUser, (Date)date)));
            response.setIssueUrl(this.getIssueUrl(report.getProjectKey(), report.getIssueKey()));
            ApplicationUser agent = (ApplicationUser)report.getAgent().getOrNull();
            URI url = this.avatarService.getAvatarAbsoluteURL(agent, agent, Avatar.Size.SMALL);
            response.setAgentAvatar(url.toASCIIString());
            return response;
        }).collect(Collectors.toList());
        FeedbackReportPageResponse reportResultResponse = new FeedbackReportPageResponse(reportResponseList, reportResult.getReportPageResponse().getTotal(), reportResult.getReportPageResponse().getStart(), reportResult.getReportPageResponse().getLimit(), reportResult.getReportPageResponse().getTotalPages());
        Option summaryResponse = reportResult.getSummary().map(FeedbackSummaryResponse::new);
        return new FeedbackReportResultResponse((FeedbackSummaryResponse)summaryResponse.getOrNull(), reportResultResponse);
    }

    private String formatFeedbackDate(@Nullable ApplicationUser loggedInUser, Date date) {
        if (loggedInUser == null) {
            return new SimpleDateFormat(FEEDBACK_DATE_FORMAT).format(date);
        }
        DateTimeFormatter dateFormatter = this.dateTimeFormatter.forUser(loggedInUser).withStyle(DateTimeStyle.RELATIVE);
        return dateFormatter.format(date);
    }

    private String getIssueUrl(String projectKey, String issueKey) {
        URI issueURI = this.projectUrlsProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.RELATIVE).issue(issueKey);
        return issueURI.toASCIIString();
    }
}

