/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers.share.response;

import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.rest.customers.share.response.ParticipantResponseType;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ShareSearchItemResponse
extends LinkedHashMap<String, Object> {
    private static final String DISPLAY_NAME = "displayName";
    private static final String USER_KEY = "userKey";
    private static final String EMAIL_ADDRESS = "emailAddress";
    private static final String AVATAR = "avatar";
    private static final String TYPE = "type";
    private static final String ID = "id";

    public ShareSearchItemResponse(@Nonnull CheckedUser user, String avatar) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(avatar);
        this.put(ID, user.getName());
        this.put(USER_KEY, user.getKey());
        this.put(DISPLAY_NAME, user.getDisplayName());
        this.put(EMAIL_ADDRESS, user.getEmailAddress());
        this.put(AVATAR, avatar);
        this.put(TYPE, ParticipantResponseType.USER);
    }

    public ShareSearchItemResponse(@Nonnull CustomerOrganization customerOrganisation) {
        Objects.requireNonNull(customerOrganisation);
        this.put(ID, customerOrganisation.getId());
        this.put(DISPLAY_NAME, customerOrganisation.getName());
        this.put(TYPE, ParticipantResponseType.ORGANISATION);
    }
}

