/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers;

import com.atlassian.jira.avatar.AvatarPickerHelperImpl;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.user.UserResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerPasswordService;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerProfileService;
import com.atlassian.servicedesk.internal.feature.customer.user.UserAvatarCreateService;
import com.atlassian.servicedesk.internal.rest.customers.request.ChangePasswordRequest;
import com.atlassian.servicedesk.internal.rest.customers.request.ProfileUpdateRequest;
import com.atlassian.servicedesk.internal.soy.SoyRenderingHelper;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/customer/user")
public class UserResource {
    private final CustomerProfileService profileService;
    private final UserFactory userFactory;
    private final UserResponseProvider userProvider;
    private final RestResponseHelper restResponseHelper;
    private final UserAvatarCreateService userAvatarCreateService;
    private final SoyRenderingHelper soyRenderingHelper;
    private final CustomerPasswordService customerPasswordService;
    private final Gson gson;

    public UserResource(CustomerProfileService profileService, UserFactory sdUserFactory, UserResponseProvider userProvider, RestResponseHelper restResponseHelper, UserAvatarCreateService userAvatarCreateService, SoyRenderingHelper soyRenderingHelper, CustomerPasswordService customerPasswordService) {
        this.profileService = profileService;
        this.userFactory = sdUserFactory;
        this.userProvider = userProvider;
        this.restResponseHelper = restResponseHelper;
        this.userAvatarCreateService = userAvatarCreateService;
        this.soyRenderingHelper = soyRenderingHelper;
        this.customerPasswordService = customerPasswordService;
        this.gson = new Gson();
    }

    @PUT
    public Response updateProfile(ProfileUpdateRequest req) throws IOException {
        return (Response)this.userFactory.getCheckedUser().fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), checkedUser -> this.updateProfileInternal((CheckedUser)checkedUser, req));
    }

    private Response updateProfileInternal(CheckedUser checkedUser, ProfileUpdateRequest req) {
        return (Response)this.profileService.updateProfile(checkedUser, req).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).validationErrorsToResponse(arg_0), this::handleUserProfileUpdateResult);
    }

    @POST
    @Path(value="avatar/temporary")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public Response uploadTemporaryAvatar(@MultipartFormParam(value="avatar") FilePart filePart, @Context HttpServletRequest request) {
        return (Response)this.userFactory.getCheckedUser().fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), checkedUser -> this.uploadTemporaryAvatarInternal((CheckedUser)checkedUser, filePart));
    }

    private Response uploadTemporaryAvatarInternal(CheckedUser checkedUser, FilePart filePart) {
        try {
            AvatarPickerHelperImpl.Result<AvatarPickerHelperImpl.TemporaryAvatarBean> result = this.userAvatarCreateService.uploadTemporary(checkedUser, filePart.getInputStream(), filePart.getContentType());
            if (result.isValid()) {
                return this.respondForIframe((Map)ImmutableMap.of((Object)"url", (Object)((AvatarPickerHelperImpl.TemporaryAvatarBean)result.getResult()).getUrl()));
            }
            return this.respondForIframe((Map)ImmutableMap.of((Object)"errorMessages", (Object)result.getErrorCollection().getErrorMessages()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Response respondForIframe(Map<String, T> json) {
        return Response.ok((Object)this.soyRenderingHelper.streamSoy("com.atlassian.servicedesk:soy/ServiceDesk.Templates.Shared.AvatarPicker.iframeResponse", (Map<String, Object>)ImmutableMap.of((Object)"json", (Object)this.toJson(json)))).build();
    }

    private <T> String toJson(Map<String, T> data) {
        return this.gson.toJson(data);
    }

    @GET
    public Response getProfile() {
        return (Response)this.userFactory.getCheckedUser().fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), checkedUser -> Response.ok((Object)this.userProvider.toUserResponse((CheckedUser)checkedUser)).build());
    }

    @PUT
    @Path(value="password")
    public Response changePassword(ChangePasswordRequest req) {
        return (Response)this.userFactory.getCheckedUser().fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), checkedUser -> this.changePasswordInternal((CheckedUser)checkedUser, req));
    }

    private Response changePasswordInternal(CheckedUser checkedUser, ChangePasswordRequest request) {
        return (Response)this.customerPasswordService.changePassword(checkedUser, request).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).validationErrorsToResponse(arg_0), this::handleChangePasswordResult);
    }

    private Response handleChangePasswordResult(Either<AnError, CheckedUser> result) {
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), checkedUser -> Response.noContent().build());
    }

    private Response handleUserProfileUpdateResult(Either<AnError, CheckedUser> result) {
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), checkedUser -> Response.ok((Object)this.userProvider.toUserResponse((CheckedUser)checkedUser)).build());
    }
}

