/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.customers.CustomersPageDataProvider;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="pages/people/customers/pagination/{projectKey}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomerPageResource {
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final CustomersPageDataProvider customersPageDataProvider;
    private final RestResponseHelper restResponseHelper;

    @Autowired
    protected CustomerPageResource(UserFactory userFactory, ServiceDeskProjectService serviceDeskProjectService, CustomersPageDataProvider customersPageDataProvider, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.customersPageDataProvider = customersPageDataProvider;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response getCustomersPage(@PathParam(value="projectKey") String projectKey) {
        return this.doGetCustomerPage(projectKey);
    }

    @GET
    @Path(value="search")
    public Response searchCustomers(@PathParam(value="projectKey") String projectKey, @QueryParam(value="query") String query, @QueryParam(value="page") @DefaultValue(value="1") int pageNumber) {
        return this.doSearchCustomers(projectKey, query, pageNumber);
    }

    private Response doGetCustomerPage(String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.customersPageDataProvider::getData).yield((user, project, data) -> data);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private Response doSearchCustomers(String projectKey, String query, int pageNumber) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.customersPageDataProvider.searchCustomers((CheckedUser)user, (Project)project, query, pageNumber)).yield((user, project, data) -> data);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }
}

