/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.always;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.bootstrap.lifecycle.Launcher;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="support")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SupportResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final Launcher launcher;

    public SupportResource(JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, Launcher launcher) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.launcher = launcher;
    }

    @POST
    @Path(value="/recycle")
    public Response resetJSD() {
        if (!this.checkResetPermissions()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.accessErrMsg()).type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        this.launcher.restartPlugin();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    private boolean checkResetPermissions() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.hasPermission(user, GlobalPermissionKey.ADMINISTER) | this.hasPermission(user, GlobalPermissionKey.SYSTEM_ADMIN);
    }

    private boolean hasPermission(ApplicationUser user, GlobalPermissionKey permission) {
        return this.globalPermissionManager.hasPermission(permission, user);
    }

    private String accessErrMsg() {
        return "You must be an administrator or system administrator to access this resource";
    }
}

