/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.admin;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.admin.EmailCreateCustomerMode;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsService;
import com.atlassian.servicedesk.internal.admin.EmailTrimmingMode;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.admin.SetCustomerCreateModeRequest;
import com.atlassian.servicedesk.internal.rest.admin.SetCustomerCreateModeResponse;
import com.atlassian.servicedesk.internal.rest.admin.SetFormattingEnabledRequest;
import com.atlassian.servicedesk.internal.rest.admin.SetFormattingEnabledResponse;
import com.atlassian.servicedesk.internal.rest.admin.SetOutsiderCommentsEnabledRequest;
import com.atlassian.servicedesk.internal.rest.admin.SetOutsiderCommentsEnabledResponse;
import com.atlassian.servicedesk.internal.rest.admin.SetTrimmingModeRequest;
import com.atlassian.servicedesk.internal.rest.admin.SetTrimmingModeResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/email-requests")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GlobalEmailRequestsSettingsResource {
    private final UserFactory userFactory;
    private final EmailRequestsSettingsService emailRequestsSettingsService;
    private final RestResponseHelper restResponseHelper;

    public GlobalEmailRequestsSettingsResource(UserFactory userFactory, EmailRequestsSettingsService emailRequestsSettingsService, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.emailRequestsSettingsService = emailRequestsSettingsService;
        this.restResponseHelper = restResponseHelper;
    }

    @PUT
    @Path(value="/outsider-comments")
    public Response setOutsiderCommentsState(SetOutsiderCommentsEnabledRequest setOutsiderCommentsEnabledRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.emailRequestsSettingsService.setOutsiderCommentsEnabled(user.forJIRA(), setOutsiderCommentsEnabledRequest.outsiderCommentsEnabled)).then((user, updatedState) -> io.atlassian.fugue.Either.right((Object)new SetOutsiderCommentsEnabledResponse((boolean)updatedState))).yield((user, updatedState, response) -> response);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="/formatting")
    public Response setEmailFormattingState(SetFormattingEnabledRequest setFormattingEnabledRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.emailRequestsSettingsService.setEmailFormattingEnabled(user.forJIRA(), setFormattingEnabledRequest.formattingEnabled)).then((user, updatedState) -> io.atlassian.fugue.Either.right((Object)new SetFormattingEnabledResponse((boolean)updatedState))).yield((user, updatedState, response) -> response);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="/trimming")
    public Response setEmailTrimmingMode(SetTrimmingModeRequest setTrimmingModeRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.emailRequestsSettingsService.setEmailTrimmingMode(user.forJIRA(), setTrimmingModeRequest.mode)).then((user, updatedState) -> io.atlassian.fugue.Either.right((Object)new SetTrimmingModeResponse((EmailTrimmingMode)((Object)updatedState)))).yield((user, updatedState, response) -> response);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="/customer-creation")
    public Response setCustomerCreateMode(SetCustomerCreateModeRequest setCustomerCreateModeRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.emailRequestsSettingsService.setEmailCreateCustomerMode(user.forJIRA(), setCustomerCreateModeRequest.mode)).then((user, updatedState) -> io.atlassian.fugue.Either.right((Object)new SetCustomerCreateModeResponse((EmailCreateCustomerMode)((Object)updatedState)))).yield((user, updatedState, response) -> response);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }
}

