/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Option;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.Errors;
import com.atlassian.pocketknife.api.rest.RestErrorResponse;
import com.atlassian.pocketknife.api.rest.RestfulTableErrorResponse;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.error.InlineEditError;
import com.atlassian.servicedesk.internal.api.error.NamedErrors;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.util.CollectorsHelper;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Options;
import io.atlassian.fugue.Pair;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class RestResponseHelperImpl
implements RestResponseHelper {
    private final UserFactory userFactory;
    private final ErrorTranslationHelper errorTranslationHelper;

    @Autowired
    public RestResponseHelperImpl(UserFactory userFactory, ErrorTranslationHelper errorTranslationHelper) {
        this.userFactory = userFactory;
        this.errorTranslationHelper = errorTranslationHelper;
    }

    public Response anErrorToResponse(AnError anError) {
        I18nHelper i18nHelper = this.userFactory.getUncheckedUser().i18NHelper();
        String translatedErrorMessage = this.errorTranslationHelper.translateAnError(anError, i18nHelper);
        String reasonKey2 = RestResponseHelperImpl.extractReasonKey(anError, translatedErrorMessage);
        int httpStatusCode = anError.getHttpStatusCode();
        return this.createErrorResponse(translatedErrorMessage, reasonKey2, httpStatusCode);
    }

    public Response errorsToResponse(Errors errors) {
        I18nHelper i18nHelper = this.userFactory.getUncheckedUser().i18NHelper();
        List<String> translatedErrorResponses = errors.getErrors().stream().map(errorMessage -> this.errorTranslationHelper.translateErrorMessage(errorMessage, i18nHelper)).collect(Collectors.toList());
        String reasonKey2 = RestResponseHelperImpl.extractReasonKey(errors, (String)Iterables.first(translatedErrorResponses).getOrNull());
        Response.Status status = Response.Status.fromStatusCode((int)errors.getHttpStatusCode());
        RestErrorResponse error = new RestErrorResponse(reasonKey2, String.valueOf(status.getStatusCode()));
        translatedErrorResponses.forEach(arg_0 -> ((RestErrorResponse)error).addError(arg_0));
        return Response.status((Response.Status)status).entity((Object)error).build();
    }

    public Response validationErrorsToResponse(ValidationErrors validationErrors) {
        I18nHelper i18nHelper = this.userFactory.getUncheckedUser().i18NHelper();
        int httpStatusCode = validationErrors.getHttpStatusCode();
        RestErrorResponse error = new RestErrorResponse(validationErrors.getReasonKey(), String.valueOf(httpStatusCode));
        validationErrors.getErrorMessages().stream().map(message -> this.errorTranslationHelper.translateErrorMessage(message, i18nHelper)).forEach(arg_0 -> ((RestErrorResponse)error).addError(arg_0));
        Maps.transformValues((Map)validationErrors.getFieldErrors(), message -> this.errorTranslationHelper.translateErrorMessage(message, i18nHelper)).entrySet().forEach(entry -> error.addError((String)entry.getValue(), (String)entry.getKey()));
        return Response.status((int)httpStatusCode).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response namedErrorsToResponse(NamedErrors namedErrors) {
        I18nHelper i18nHelper = this.userFactory.getUncheckedUser().i18NHelper();
        List i18nFieldValues = namedErrors.getErrors().values().stream().map(ErrorMessage::getI18n).map(StepsConverters::newerOption).collect(Collectors.toList());
        Map translatedFieldErrorResponses = (Map)namedErrors.getErrors().entrySet().stream().map(entry -> Pair.pair(entry.getKey(), (Object)this.errorTranslationHelper.translateErrorMessage((ErrorMessage)entry.getValue(), i18nHelper))).collect(CollectorsHelper.toLinkedHashMap(Pair::left, Pair::right));
        String reasonKey2 = RestResponseHelperImpl.extractReasonKey(namedErrors, (String)Iterables.first(translatedFieldErrorResponses.entrySet()).map(Map.Entry::getValue).getOrNull(), (io.atlassian.fugue.Option<ErrorMessage.I18n>)Iterables.first((Iterable)Options.flatten(i18nFieldValues)));
        return Response.status((int)namedErrors.getHttpStatusCode()).entity((Object)new RestfulTableErrorResponse(reasonKey2, translatedFieldErrorResponses)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response inlineEditErrorToResponse(InlineEditError inlineEditError) {
        String translatedErrorMessage = this.errorTranslationHelper.translateErrorMessage(inlineEditError.getErrorMessage());
        return Response.status((int)inlineEditError.getHttpStatusCode()).entity(Collections.singletonMap(inlineEditError.getFieldName(), translatedErrorMessage)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public <T> Response anErrorEitherToOkResponse(Either<AnError, T> anErrorEither) {
        return (Response)anErrorEither.fold(this::anErrorToResponse, this::ok);
    }

    public Response anErrorEitherToNoContentResponse(Either<AnError, Unit> anErrorEither) {
        return (Response)anErrorEither.fold(this::anErrorToResponse, unit -> this.noContent());
    }

    public <T> Response errorsEitherToOkResponse(Either<Errors, T> errorsEither) {
        return (Response)errorsEither.fold(this::errorsToResponse, this::ok);
    }

    public Response errorsEitherToNoContentResponse(Either<Errors, Unit> errorsEither) {
        return (Response)errorsEither.fold(this::errorsToResponse, unit -> this.noContent());
    }

    public <T> Response namedErrorsEitherToOkResponse(Either<NamedErrors, T> errorsEither) {
        return (Response)errorsEither.fold(this::namedErrorsToResponse, this::ok);
    }

    public Response namedErrorsEitherToNoContentResponse(Either<NamedErrors, Unit> errorsEither) {
        return (Response)errorsEither.fold(this::namedErrorsToResponse, unit -> this.noContent());
    }

    public <T> Response validationErrorsEitherToOkResponse(Either<ValidationErrors, T> anErrorEither) {
        return (Response)anErrorEither.fold(this::validationErrorsToResponse, this::ok);
    }

    public Response validationErrorsEitherToNoContentResponse(Either<ValidationErrors, Unit> anErrorEither) {
        return (Response)anErrorEither.fold(this::validationErrorsToResponse, unit -> this.noContent());
    }

    public <T> Response ok(T entity) {
        return Response.ok((Object)Assertions.notNull((String)"entity", entity)).cacheControl(this.never()).build();
    }

    public Response noContent() {
        return Response.noContent().build();
    }

    public <T> Response badRequest(@Nonnull T entity) {
        Assertions.notNull((String)"entity", entity);
        Response.Status badRequest2 = Response.Status.BAD_REQUEST;
        return Response.status((Response.Status)badRequest2).entity(entity).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response badRequest(String reasonKey2) {
        Assertions.is((String)"reasonKey", (boolean)StringUtils.isNotBlank((String)reasonKey2));
        Response.Status badRequest2 = Response.Status.BAD_REQUEST;
        RestErrorResponse error = new RestErrorResponse(reasonKey2, String.valueOf(badRequest2.getStatusCode()));
        return Response.status((Response.Status)badRequest2).entity((Object)error).build();
    }

    private Response createErrorResponse(String translatedErrorMessage, String reasonKey2, int httpStatusCode) {
        RestErrorResponse error = new RestErrorResponse(reasonKey2, String.valueOf(httpStatusCode));
        error.addError(translatedErrorMessage);
        return Response.status((int)httpStatusCode).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static String extractReasonKey(AnError anError, String translatedErrorMessage) {
        return (String)anError.getErrorCode().map(ErrorCode::getErrorCode).orElse(() -> anError.getMessage().getI18n().map(ErrorMessage.I18n::getI18nKey)).getOrElse((Object)translatedErrorMessage);
    }

    private static String extractReasonKey(Errors errors, String translatedErrorMessage) {
        return (String)StepsConverters.newerOption((Option)errors.getErrorCode()).map(ErrorCode::getErrorCode).orElse(() -> Iterables.first((Iterable)errors.getErrors()).flatMap(errorMessage -> StepsConverters.newerOption((Option)errorMessage.getI18n())).map(ErrorMessage.I18n::getI18nKey)).getOrElse((Object)translatedErrorMessage);
    }

    private static String extractReasonKey(NamedErrors namedErrors, String translatedErrorMessage, io.atlassian.fugue.Option<ErrorMessage.I18n> i18n) {
        return (String)namedErrors.getErrorCode().map(ErrorCode::getErrorCode).orElse(() -> i18n.map(ErrorMessage.I18n::getI18nKey)).getOrElse((Object)translatedErrorMessage);
    }

    private CacheControl never() {
        CacheControl cacheNever = new CacheControl();
        cacheNever.setNoStore(true);
        cacheNever.setNoCache(true);
        return cacheNever;
    }
}

